/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.biome.cold;

import com.terraformersmc.biolith.api.biome.BiomePlacement;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.api.biome.sub.CriterionBuilder;
import com.terraformersmc.biolith.api.biome.sub.RatioTargets;
import com.terraformersmc.biolith.api.surface.BiolithSurfaceBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;
import net.satisfy.bloomingnature.core.world.biome.BloomingNatureBiomeKeys;

public final class ColdBiomeRegistry
extends BiolithSurfaceBuilder {
    public static void registerBiomePlacement() {
        ColdBiomeRegistry.registerColdRiverPlacement();
        ColdBiomeRegistry.registerColdGrasslandPlacement();
        ColdBiomeRegistry.registerLarchForestPlacement();
        ColdBiomeRegistry.registerFenPlacement();
        ColdBiomeRegistry.registerHighlandWoodsPlacement();
    }

    private static void registerColdRiverPlacement() {
        Criterion coldBiomes = CriterionBuilder.anyOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor((ResourceKey)Biomes.SNOWY_TAIGA), CriterionBuilder.neighbor((ResourceKey)Biomes.TAIGA), CriterionBuilder.neighbor((ResourceKey)Biomes.OLD_GROWTH_SPRUCE_TAIGA), CriterionBuilder.neighbor((ResourceKey)Biomes.OLD_GROWTH_PINE_TAIGA), CriterionBuilder.neighbor(BloomingNatureBiomeKeys.LARCH_FOREST), CriterionBuilder.neighbor(BloomingNatureBiomeKeys.COLD_GRASSLAND)});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.RIVER, BloomingNatureBiomeKeys.COLD_RIVER, (Criterion)coldBiomes);
    }

    private static void registerColdGrasslandPlacement() {
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.TAIGA, BloomingNatureBiomeKeys.COLD_GRASSLAND, (double)0.3);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.SNOWY_TAIGA, BloomingNatureBiomeKeys.COLD_GRASSLAND, (double)0.3);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.OLD_GROWTH_SPRUCE_TAIGA, BloomingNatureBiomeKeys.COLD_GRASSLAND, (double)0.1);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.OLD_GROWTH_PINE_TAIGA, BloomingNatureBiomeKeys.COLD_GRASSLAND, (double)0.1);
    }

    private static void registerLarchForestPlacement() {
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.TAIGA, BloomingNatureBiomeKeys.LARCH_FOREST, (double)0.1);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.SNOWY_TAIGA, BloomingNatureBiomeKeys.LARCH_FOREST, (double)0.4);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.OLD_GROWTH_SPRUCE_TAIGA, BloomingNatureBiomeKeys.LARCH_FOREST, (double)0.125);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.OLD_GROWTH_PINE_TAIGA, BloomingNatureBiomeKeys.LARCH_FOREST, (double)0.125);
    }

    private static void registerFenPlacement() {
        Criterion coldNeighbors = CriterionBuilder.anyOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor((ResourceKey)Biomes.TAIGA), CriterionBuilder.neighbor((ResourceKey)Biomes.SNOWY_TAIGA), CriterionBuilder.neighbor((ResourceKey)Biomes.OLD_GROWTH_SPRUCE_TAIGA), CriterionBuilder.neighbor((ResourceKey)Biomes.OLD_GROWTH_PINE_TAIGA), CriterionBuilder.neighbor(BloomingNatureBiomeKeys.LARCH_FOREST), CriterionBuilder.neighbor(BloomingNatureBiomeKeys.COLD_GRASSLAND)});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.RIVER, BloomingNatureBiomeKeys.FEN, (Criterion)coldNeighbors);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.FROZEN_RIVER, BloomingNatureBiomeKeys.FEN, (Criterion)coldNeighbors);
        BiomePlacement.addSubOverworld(BloomingNatureBiomeKeys.COLD_RIVER, BloomingNatureBiomeKeys.FEN, (Criterion)coldNeighbors);
        Criterion riverTouch = CriterionBuilder.anyOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor((ResourceKey)Biomes.RIVER), CriterionBuilder.neighbor((ResourceKey)Biomes.FROZEN_RIVER), CriterionBuilder.neighbor(BloomingNatureBiomeKeys.COLD_RIVER)});
        Criterion shoreZone = CriterionBuilder.ratio((RatioTargets)RatioTargets.EDGE, (float)0.0f, (float)0.45f);
        Criterion inlandZone = CriterionBuilder.ratio((RatioTargets)RatioTargets.EDGE, (float)0.45f, (float)1.0f);
        Criterion shoreCond = CriterionBuilder.allOf((Criterion[])new Criterion[]{riverTouch, shoreZone});
        Criterion inlandCond = CriterionBuilder.allOf((Criterion[])new Criterion[]{riverTouch, inlandZone});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.TAIGA, BloomingNatureBiomeKeys.FEN, (Criterion)shoreCond);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.SNOWY_TAIGA, BloomingNatureBiomeKeys.FEN, (Criterion)shoreCond);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.OLD_GROWTH_SPRUCE_TAIGA, BloomingNatureBiomeKeys.FEN, (Criterion)shoreCond);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.OLD_GROWTH_PINE_TAIGA, BloomingNatureBiomeKeys.FEN, (Criterion)shoreCond);
        BiomePlacement.addSubOverworld(BloomingNatureBiomeKeys.LARCH_FOREST, BloomingNatureBiomeKeys.FEN, (Criterion)shoreCond);
        BiomePlacement.addSubOverworld(BloomingNatureBiomeKeys.COLD_GRASSLAND, BloomingNatureBiomeKeys.FEN, (Criterion)shoreCond);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.TAIGA, BloomingNatureBiomeKeys.FEN, (Criterion)inlandCond);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.SNOWY_TAIGA, BloomingNatureBiomeKeys.FEN, (Criterion)inlandCond);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.OLD_GROWTH_SPRUCE_TAIGA, BloomingNatureBiomeKeys.FEN, (Criterion)inlandCond);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.OLD_GROWTH_PINE_TAIGA, BloomingNatureBiomeKeys.FEN, (Criterion)inlandCond);
        BiomePlacement.addSubOverworld(BloomingNatureBiomeKeys.LARCH_FOREST, BloomingNatureBiomeKeys.FEN, (Criterion)inlandCond);
        BiomePlacement.addSubOverworld(BloomingNatureBiomeKeys.COLD_GRASSLAND, BloomingNatureBiomeKeys.FEN, (Criterion)inlandCond);
    }

    private static void registerHighlandWoodsPlacement() {
        Criterion nearCold = CriterionBuilder.anyOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor((ResourceKey)Biomes.TAIGA), CriterionBuilder.neighbor((ResourceKey)Biomes.SNOWY_TAIGA), CriterionBuilder.neighbor((ResourceKey)Biomes.OLD_GROWTH_SPRUCE_TAIGA), CriterionBuilder.neighbor((ResourceKey)Biomes.OLD_GROWTH_PINE_TAIGA), CriterionBuilder.neighbor(BloomingNatureBiomeKeys.LARCH_FOREST), CriterionBuilder.neighbor(BloomingNatureBiomeKeys.COLD_RIVER), CriterionBuilder.neighbor((ResourceKey)Biomes.FROZEN_RIVER)});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.PLAINS, BloomingNatureBiomeKeys.HIGHLAND_WOODS, (Criterion)nearCold);
        BiomePlacement.addSubOverworld(BloomingNatureBiomeKeys.COLD_GRASSLAND, BloomingNatureBiomeKeys.HIGHLAND_WOODS, (Criterion)nearCold);
    }
}

