/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.biome.cold.surface;

import com.terraformersmc.biolith.api.surface.BiolithSurfaceBuilder;
import com.terraformersmc.biolith.api.surface.SurfaceGeneration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.satisfy.bloomingnature.BloomingNature;
import net.satisfy.bloomingnature.core.registry.ObjectRegistry;
import net.satisfy.bloomingnature.core.world.biome.BloomingNatureBiomeKeys;

public final class ColdSurfaceBuilder
extends BiolithSurfaceBuilder {
    private final Profile profile;

    public ColdSurfaceBuilder(Profile profile) {
        this.profile = profile;
    }

    public void generate(BiomeManager biomeManager, BlockColumn column, RandomSource random, ChunkAccess chunk, Biome biome, int x, int z, int vHeight, int seaLevel) {
        int localX = x & 0xF;
        int localZ = z & 0xF;
        int topY = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, localZ);
        int westX = localX > 0 ? localX - 1 : localX;
        int eastX = localX < 15 ? localX + 1 : localX;
        int northZ = localZ > 0 ? localZ - 1 : localZ;
        int southZ = localZ < 15 ? localZ + 1 : localZ;
        int heightNorth = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, northZ);
        int heightSouth = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, southZ);
        int heightWest = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, westX, localZ);
        int heightEast = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, eastX, localZ);
        int slope = Math.max(Math.max(Math.abs(topY - heightNorth), Math.abs(topY - heightSouth)), Math.max(Math.abs(topY - heightWest), Math.abs(topY - heightEast)));
        if (this.profile == Profile.COLD_GRASSLAND) {
            for (int d = 0; d <= 4 && topY - d >= 0; ++d) {
                if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            float mask = this.smoothNoise(RandomSource.create((long)912345L), x - 113, z + 271, 0.02f);
            float n1 = this.smoothNoise(RandomSource.create((long)34187L), x, z, 0.08f);
            float warpA = this.smoothNoise(RandomSource.create((long)87777L), x - 113, z + 271, 0.03f) * 6.0f;
            float warpB = this.smoothNoise(RandomSource.create((long)12341L), x + 47, z - 31, 0.07f) * 2.5f;
            float patchNoise = this.smoothNoise(RandomSource.create((long)44417L), x + (int)warpA, z + (int)warpB, 0.028f);
            float detailNoise = this.smoothNoise(RandomSource.create((long)90123L), x, z, 0.085f);
            boolean inPatch = patchNoise > 0.74f && detailNoise > 0.45f;
            for (int y = 0; y <= topY; ++y) {
                if (y != topY) continue;
                if (slope >= 3) {
                    column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                    continue;
                }
                if (inPatch) {
                    int mix = this.mixIndex(x, y, z);
                    if (mix < 90) {
                        column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                        if (y - 1 < 0) continue;
                        column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.ROOTED_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (mask <= 0.7f) {
                    column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                    continue;
                }
                if (n1 > 0.85f) {
                    column.setBlock(y, Blocks.ROOTED_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (n1 > 0.7f) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.OLD_GROWTH_SPRUCE_TAIGA || this.profile == Profile.LARCH_FOREST) {
            for (int y = 0; y <= topY; ++y) {
                if (!column.getBlock(y).is(Blocks.SAND)) continue;
                column.setBlock(y, Blocks.DIRT.defaultBlockState());
            }
            for (int depth = 0; depth <= 4 && topY - depth >= 0; ++depth) {
                if (!column.getBlock(topY - depth).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            float soilNoise = this.smoothNoise(RandomSource.create((long)23874L), x, z, 0.08f);
            float mossNoise = this.smoothNoise(RandomSource.create((long)57813L), x + 31, z - 11, 0.12f);
            float podzolNoise = this.smoothNoise(RandomSource.create((long)98723L), x - 12, z + 91, 0.06f);
            for (int y = 0; y <= topY; ++y) {
                if (y != topY) continue;
                BlockState state = column.getBlock(y);
                if (slope >= 3 && state.is(Blocks.STONE)) {
                    int stoneIndex = this.mixIndex(x, y, z);
                    if (stoneIndex < 35) {
                        column.setBlock(y, Blocks.STONE.defaultBlockState());
                        continue;
                    }
                    if (stoneIndex < 65) {
                        column.setBlock(y, Blocks.COBBLESTONE.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.MOSSY_COBBLESTONE.defaultBlockState());
                    continue;
                }
                if (podzolNoise > 0.45f) {
                    column.setBlock(y, Blocks.PODZOL.defaultBlockState());
                    continue;
                }
                if (slope >= 2 || soilNoise > 0.35f) {
                    int coarseIndex = this.mixIndex(x, y, z);
                    if (coarseIndex < 10) {
                        column.setBlock(y, Blocks.ROOTED_DIRT.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    continue;
                }
                if (mossNoise > 0.75f && podzolNoise < 0.35f) {
                    column.setBlock(y, ((Block)ObjectRegistry.FOREST_MOSS.get()).defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (soilNoise > 0.25f) {
                    column.setBlock(y, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.TAIGA) {
            for (int y = 0; y <= topY; ++y) {
                if (!column.getBlock(y).is(Blocks.SAND)) continue;
                column.setBlock(y, Blocks.DIRT.defaultBlockState());
            }
            for (int d = 0; d <= 4 && topY - d >= 0; ++d) {
                if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            if (column.getBlock(topY + 1).getFluidState().is(FluidTags.WATER)) {
                return;
            }
            float soilNoise = this.smoothNoise(RandomSource.create((long)23874L), x, z, 0.1f);
            float mossNoise = this.smoothNoise(RandomSource.create((long)57813L), x + 17, z - 43, 0.15f);
            float podzolNoise = this.smoothNoise(RandomSource.create((long)98723L), x - 23, z + 61, 0.09f);
            for (int y = 0; y <= topY; ++y) {
                if (y != topY) continue;
                BlockState state = column.getBlock(y);
                if (slope >= 3 && state.is(Blocks.STONE)) {
                    if (y - 1 < 0 || column.getBlock(y - 1).isAir()) continue;
                    int r = this.mixIndex(x, y, z);
                    if (r < 40) {
                        column.setBlock(y, Blocks.STONE.defaultBlockState());
                        continue;
                    }
                    if (r < 70) {
                        column.setBlock(y, Blocks.COBBLESTONE.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.MOSSY_COBBLESTONE.defaultBlockState());
                    continue;
                }
                if (soilNoise > 0.9f) {
                    column.setBlock(y, Blocks.ROOTED_DIRT.defaultBlockState());
                    continue;
                }
                if (podzolNoise > 0.8f) {
                    column.setBlock(y, Blocks.PODZOL.defaultBlockState());
                    continue;
                }
                if (soilNoise > 0.7f) {
                    column.setBlock(y, ((Block)ObjectRegistry.FOREST_MOSS.get()).defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (mossNoise < 0.25f && slope >= 3) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.FEN) {
            BlockState belowState;
            BlockState topState;
            int surfaceY;
            for (int scanY = 0; scanY <= topY; ++scanY) {
                if (!column.getBlock(scanY).is(Blocks.SAND)) continue;
                column.setBlock(scanY, Blocks.DIRT.defaultBlockState());
            }
            for (surfaceY = topY; surfaceY > 0 && column.getBlock(surfaceY).getFluidState().is(FluidTags.WATER); --surfaceY) {
            }
            while (surfaceY > 0 && column.getBlock(surfaceY).isAir()) {
                --surfaceY;
            }
            if (surfaceY <= 1) {
                return;
            }
            float mossNoise = this.smoothNoise(RandomSource.create((long)77113L), x + 19, z - 37, 0.09f);
            float coarseNoise = this.smoothNoise(RandomSource.create((long)88217L), x - 41, z + 23, 0.075f);
            float mudNoise = this.smoothNoise(RandomSource.create((long)91337L), x + 7, z + 11, 0.11f);
            boolean mossPatch = mossNoise > 0.62f;
            boolean coarsePatch = coarseNoise > 0.72f;
            boolean rareMudPatch = mudNoise > 0.89f;
            int y = surfaceY;
            boolean aboveWater = column.getBlock(y + 1).getFluidState().is(FluidTags.WATER);
            if (slope >= 3) {
                topState = Blocks.GRASS_BLOCK.defaultBlockState();
                mix = Math.floorMod(this.mixIndex(x, y - 1, z), 100);
                belowState = mix < 70 ? Blocks.MUD.defaultBlockState() : Blocks.COARSE_DIRT.defaultBlockState();
            } else if (rareMudPatch) {
                topState = Blocks.MUD.defaultBlockState();
                belowState = Blocks.MUD.defaultBlockState();
            } else if (mossPatch && !aboveWater) {
                topState = ((Block)ObjectRegistry.FEN_MOSS.get()).defaultBlockState();
                belowState = Blocks.MUD.defaultBlockState();
            } else if (coarsePatch) {
                topState = Blocks.COARSE_DIRT.defaultBlockState();
                belowState = Blocks.MUD.defaultBlockState();
            } else {
                topState = Blocks.GRASS_BLOCK.defaultBlockState();
                mix = Math.floorMod(this.mixIndex(x, y - 1, z), 100);
                belowState = mix < 70 ? Blocks.MUD.defaultBlockState() : Blocks.COARSE_DIRT.defaultBlockState();
            }
            column.setBlock(y, topState);
            column.setBlock(y - 1, belowState);
            for (int subY = y - 2; subY >= y - 5 && subY >= 0; --subY) {
                int clayMix = Math.floorMod(this.mixIndex(x, subY, z), 100);
                column.setBlock(subY, clayMix < 85 ? Blocks.CLAY.defaultBlockState() : Blocks.COARSE_DIRT.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.OLD_GROWTH_PINE_TAIGA) {
            for (int y = 0; y <= topY; ++y) {
                if (!column.getBlock(y).is(Blocks.SAND)) continue;
                column.setBlock(y, Blocks.DIRT.defaultBlockState());
            }
            for (int d = 0; d <= 4 && topY - d >= 0; ++d) {
                if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            float soilNoise = this.smoothNoise(RandomSource.create((long)23874L), x, z, 0.09f);
            float mossNoise = this.smoothNoise(RandomSource.create((long)57813L), x + 9, z - 21, 0.11f);
            float dryNoise = this.smoothNoise(RandomSource.create((long)98723L), x - 17, z + 47, 0.08f);
            for (int y = 0; y <= topY; ++y) {
                if (y != topY) continue;
                BlockState state = column.getBlock(y);
                if (slope >= 4 && state.is(Blocks.STONE)) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    continue;
                }
                if (slope == 3 && state.is(Blocks.STONE)) {
                    int r = this.mixIndex(x, y, z);
                    if (r < 55) {
                        column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
                    continue;
                }
                if (mossNoise > 0.78f && slope <= 2) {
                    column.setBlock(y, ((Block)ObjectRegistry.FOREST_MOSS.get()).defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (soilNoise > 0.7f) {
                    column.setBlock(y, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (soilNoise > 0.5f && dryNoise < 0.55f) {
                    column.setBlock(y, Blocks.PODZOL.defaultBlockState());
                    continue;
                }
                if (dryNoise > 0.6f) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.COLD_RIVER) {
            int topSurfaceY;
            int waterTopY;
            int bedrockY = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, localX, localZ);
            for (waterTopY = topSurfaceY = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, localZ); waterTopY > bedrockY && column.getBlock(waterTopY).getFluidState().is(FluidTags.WATER); --waterTopY) {
            }
            boolean hasWater = waterTopY < topSurfaceY && column.getBlock(waterTopY + 1).getFluidState().is(FluidTags.WATER);
            int maxDepth = hasWater ? 3 : 0;
            float bedNoise = this.smoothNoise(RandomSource.create((long)31117L), x, z, 0.11f);
            float pocketNoise = this.smoothNoise(RandomSource.create((long)17171L), x + 41, z - 33, 0.12f);
            int waterFloorY = hasWater ? bedrockY : topSurfaceY;
            int underwaterTop = hasWater ? Math.min(waterTopY - 1, bedrockY + maxDepth) : bedrockY - 1;
            for (int y = waterFloorY; y <= underwaterTop; ++y) {
                boolean belowWater;
                BlockState state = column.getBlock(y);
                boolean replaceable = state.is(Blocks.STONE) || state.is(Blocks.DIRT) || state.is(Blocks.GRAVEL) || state.is(Blocks.SAND);
                boolean bl = belowWater = column.getBlock(y + 1).getFluidState().is(FluidTags.WATER) || state.getFluidState().is(FluidTags.WATER);
                if (!replaceable || !belowWater || y - 1 < 0 || column.getBlock(y - 1).isAir()) continue;
                if (state.is(Blocks.STONE)) {
                    int chance = Math.floorMod(this.mixIndex(x, y, z), 100);
                    if (chance < 30) {
                        int mix = Math.floorMod(this.mixIndex(x, y + 11, z - 7), 100);
                        if (mix < 20) {
                            column.setBlock(y, ((Block)ObjectRegistry.MOSSY_TRAVERTIN.get()).defaultBlockState());
                        } else if (mix < 60) {
                            column.setBlock(y, ((Block)ObjectRegistry.TRAVERTIN.get()).defaultBlockState());
                        } else {
                            column.setBlock(y, ((Block)ObjectRegistry.COBBLED_TRAVERTIN.get()).defaultBlockState());
                        }
                    } else if (bedNoise > 0.75f && y <= bedrockY + 1) {
                        column.setBlock(y, Blocks.CLAY.defaultBlockState());
                    } else if (bedNoise > 0.7f && y <= bedrockY + 1) {
                        column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
                    }
                } else if (bedNoise > 0.75f && y <= bedrockY + 1) {
                    column.setBlock(y, Blocks.CLAY.defaultBlockState());
                } else if (bedNoise > 0.7f && y <= bedrockY + 1) {
                    column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
                }
                if (!column.getBlock(y).is(Blocks.SAND)) continue;
                column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
            }
            int bankTopY = hasWater ? waterTopY : topSurfaceY;
            int bankStartY = Math.max(bedrockY, bankTopY - 2);
            int bankEndY = Math.min(topSurfaceY, bankTopY + 1);
            for (int y = bankStartY; y <= bankEndY; ++y) {
                boolean replaceable;
                BlockState state = column.getBlock(y);
                boolean nearWater = y + 1 <= topSurfaceY && column.getBlock(y + 1).getFluidState().is(FluidTags.WATER) || state.getFluidState().is(FluidTags.WATER);
                boolean bl = replaceable = state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.DIRT) || state.is(Blocks.COARSE_DIRT) || state.is(Blocks.GRAVEL) || state.is(Blocks.SAND);
                if (!nearWater || !replaceable) continue;
                if (state.is(Blocks.SAND)) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    continue;
                }
                int choice = Math.floorMod(this.mixIndex(x, y, z), 100);
                if (choice < 58) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
            }
            if (!hasWater) {
                boolean groundOk;
                BlockState ground = column.getBlock(topSurfaceY);
                boolean bl = groundOk = ground.is(Blocks.GRASS_BLOCK) || ground.is(Blocks.DIRT) || ground.is(Blocks.SAND) || ground.is(Blocks.GRAVEL);
                if (groundOk && pocketNoise > 0.82f && slope >= 2) {
                    column.setBlock(topSurfaceY, Blocks.GRAVEL.defaultBlockState());
                    if (topSurfaceY - 1 >= 0 && !column.getBlock(topSurfaceY - 1).getFluidState().is(FluidTags.WATER)) {
                        column.setBlock(topSurfaceY - 1, Blocks.DIRT.defaultBlockState());
                    }
                }
            }
            return;
        }
        for (int y = 0; y <= topY; ++y) {
            if (y != topY) continue;
            column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
        }
    }

    private int mixIndex(int x, int y, int z) {
        long seed = (long)x * 341873128712L + (long)y * 132897987541L + (long)z * 42317861L;
        return RandomSource.create((long)seed).nextInt(100);
    }

    private float smoothNoise(RandomSource random, int x, int z, float scale) {
        float xf = (float)x * scale;
        float zf = (float)z * scale;
        int xi = (int)Math.floor(xf);
        int zi = (int)Math.floor(zf);
        float tx = xf - (float)xi;
        float tz = zf - (float)zi;
        random.setSeed((long)xi * 49632L + (long)zi * 325176L);
        float c = random.nextFloat();
        random.setSeed((long)(xi + 1) * 49632L + (long)zi * 325176L);
        float e = random.nextFloat();
        random.setSeed((long)xi * 49632L + (long)(zi + 1) * 325176L);
        float s = random.nextFloat();
        random.setSeed((long)(xi + 1) * 49632L + (long)(zi + 1) * 325176L);
        float se = random.nextFloat();
        float i1 = this.lerp(c, e, tx);
        float i2 = this.lerp(s, se, tx);
        return this.lerp(i1, i2, tz);
    }

    private float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public static void registerSurfaceRules() {
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("cold_river"), (BiolithSurfaceBuilder)new ColdSurfaceBuilder(Profile.COLD_RIVER).setBiomeKey(BloomingNatureBiomeKeys.COLD_RIVER));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("old_growth_spruce_taiga"), (BiolithSurfaceBuilder)new ColdSurfaceBuilder(Profile.OLD_GROWTH_SPRUCE_TAIGA).setBiomeKey(Biomes.OLD_GROWTH_SPRUCE_TAIGA));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("taiga"), (BiolithSurfaceBuilder)new ColdSurfaceBuilder(Profile.TAIGA).setBiomeKey(Biomes.TAIGA));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("old_growth_pine_taiga"), (BiolithSurfaceBuilder)new ColdSurfaceBuilder(Profile.OLD_GROWTH_PINE_TAIGA).setBiomeKey(Biomes.OLD_GROWTH_PINE_TAIGA));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("cold_grassland"), (BiolithSurfaceBuilder)new ColdSurfaceBuilder(Profile.COLD_GRASSLAND).setBiomeKey(BloomingNatureBiomeKeys.COLD_GRASSLAND));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("larch_forest"), (BiolithSurfaceBuilder)new ColdSurfaceBuilder(Profile.LARCH_FOREST).setBiomeKey(BloomingNatureBiomeKeys.LARCH_FOREST));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("highland_woods"), (BiolithSurfaceBuilder)new ColdSurfaceBuilder(Profile.OLD_GROWTH_SPRUCE_TAIGA).setBiomeKey(BloomingNatureBiomeKeys.HIGHLAND_WOODS));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("fen"), (BiolithSurfaceBuilder)new ColdSurfaceBuilder(Profile.FEN).setBiomeKey(BloomingNatureBiomeKeys.FEN));
    }

    public static enum Profile {
        FEN,
        COLD_RIVER,
        TAIGA,
        OLD_GROWTH_SPRUCE_TAIGA,
        OLD_GROWTH_PINE_TAIGA,
        COLD_GRASSLAND,
        LARCH_FOREST,
        HIGHLAND_WOODS;

    }
}

