/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.biome.temperate;

import com.terraformersmc.biolith.api.biome.BiomePlacement;
import com.terraformersmc.biolith.api.biome.sub.BiomeParameterTargets;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.api.biome.sub.CriterionBuilder;
import com.terraformersmc.biolith.api.biome.sub.RatioTargets;
import com.terraformersmc.biolith.api.surface.BiolithSurfaceBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biomes;
import net.satisfy.bloomingnature.core.world.biome.BloomingNatureBiomeKeys;

public final class TemperateBiomeRegistry
extends BiolithSurfaceBuilder {
    public static void registerBiomePlacement() {
        TemperateBiomeRegistry.registerForestEdgePlacement();
        TemperateBiomeRegistry.registerFlowerGladePlacement();
        TemperateBiomeRegistry.registerGoldenGladePlacement();
        TemperateBiomeRegistry.registerOldGrowthBirchPlacement();
        TemperateBiomeRegistry.registerAspenForestPlacement();
    }

    private static void registerForestEdgePlacement() {
        Criterion neighborAnyForest = CriterionBuilder.anyOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor((ResourceKey)Biomes.FOREST), CriterionBuilder.neighbor((ResourceKey)Biomes.FLOWER_FOREST), CriterionBuilder.neighbor((ResourceKey)Biomes.DARK_FOREST), CriterionBuilder.neighbor((ResourceKey)Biomes.BIRCH_FOREST), CriterionBuilder.neighbor((ResourceKey)Biomes.OLD_GROWTH_BIRCH_FOREST), CriterionBuilder.neighbor((ResourceKey)Biomes.OLD_GROWTH_SPRUCE_TAIGA), CriterionBuilder.neighbor((ResourceKey)Biomes.TAIGA)});
        Criterion excludeWaterAndFlowerForest = CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.not((Criterion)CriterionBuilder.neighbor((TagKey)BiomeTags.IS_RIVER)), CriterionBuilder.not((Criterion)CriterionBuilder.neighbor((TagKey)BiomeTags.IS_OCEAN)), CriterionBuilder.not((Criterion)CriterionBuilder.neighbor((ResourceKey)Biomes.FLOWER_FOREST))});
        Criterion thinEdgeBand = CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.ratio((RatioTargets)RatioTargets.EDGE, (float)0.0f, (float)0.16f), CriterionBuilder.deviationMax((BiomeParameterTargets)BiomeParameterTargets.PEAKS_VALLEYS, (float)0.08f), excludeWaterAndFlowerForest});
        Criterion edgeOnForestSide = CriterionBuilder.allOf((Criterion[])new Criterion[]{neighborAnyForest, thinEdgeBand});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.PLAINS, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.SUNFLOWER_PLAINS, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.MEADOW, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.BADLANDS, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.SAVANNA, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.SAVANNA_PLATEAU, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.STONY_PEAKS, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.SNOWY_PLAINS, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
        BiomePlacement.addSubOverworld(BloomingNatureBiomeKeys.CYPRESS_FIELDS, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
        BiomePlacement.addSubOverworld(BloomingNatureBiomeKeys.BAOBAB_SAVANNA, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
        BiomePlacement.addSubOverworld(BloomingNatureBiomeKeys.COLD_GRASSLAND, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
        BiomePlacement.addSubOverworld(BloomingNatureBiomeKeys.BRUSHLANDS, BloomingNatureBiomeKeys.FOREST_EDGE, (Criterion)edgeOnForestSide);
    }

    private static void registerFlowerGladePlacement() {
        Criterion innerBand = CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.deviationMin((BiomeParameterTargets)BiomeParameterTargets.PEAKS_VALLEYS, (float)0.06f), CriterionBuilder.ratio((RatioTargets)RatioTargets.CENTER, (float)0.24f, (float)0.3f)});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.FOREST, BloomingNatureBiomeKeys.FLOWER_GLADE, (Criterion)innerBand);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.FLOWER_FOREST, BloomingNatureBiomeKeys.FLOWER_GLADE, (Criterion)innerBand);
    }

    private static void registerGoldenGladePlacement() {
        Criterion innerBand = CriterionBuilder.allOf((Criterion[])new Criterion[]{CriterionBuilder.deviationMin((BiomeParameterTargets)BiomeParameterTargets.PEAKS_VALLEYS, (float)0.06f), CriterionBuilder.ratio((RatioTargets)RatioTargets.CENTER, (float)0.24f, (float)0.3f)});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.OLD_GROWTH_BIRCH_FOREST, BloomingNatureBiomeKeys.GOLDEN_GLADE, (Criterion)innerBand);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.BIRCH_FOREST, BloomingNatureBiomeKeys.GOLDEN_GLADE, (Criterion)innerBand);
    }

    private static void registerOldGrowthBirchPlacement() {
        Criterion neighborBirch = CriterionBuilder.neighbor((ResourceKey)Biomes.BIRCH_FOREST);
        Criterion cond = CriterionBuilder.allOf((Criterion[])new Criterion[]{neighborBirch, CriterionBuilder.ratio((RatioTargets)RatioTargets.CENTER, (float)0.2f, (float)0.26f), CriterionBuilder.deviationMin((BiomeParameterTargets)BiomeParameterTargets.PEAKS_VALLEYS, (float)0.04f)});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.BIRCH_FOREST, (ResourceKey)Biomes.OLD_GROWTH_BIRCH_FOREST, (Criterion)cond);
    }

    private static void registerAspenForestPlacement() {
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.BIRCH_FOREST, BloomingNatureBiomeKeys.ASPEN_FOREST, (double)0.55);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.OLD_GROWTH_BIRCH_FOREST, BloomingNatureBiomeKeys.ASPEN_FOREST, (double)0.85);
    }
}

