/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.biome.temperate.surface;

import com.terraformersmc.biolith.api.surface.BiolithSurfaceBuilder;
import com.terraformersmc.biolith.api.surface.SurfaceGeneration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.satisfy.bloomingnature.BloomingNature;
import net.satisfy.bloomingnature.core.registry.ObjectRegistry;
import net.satisfy.bloomingnature.core.world.biome.BloomingNatureBiomeKeys;

public final class TemperateSurfaceBuilder
extends BiolithSurfaceBuilder {
    private final Profile profile;

    public TemperateSurfaceBuilder(Profile profile) {
        this.profile = profile;
    }

    public void generate(BiomeManager biomeManager, BlockColumn column, RandomSource random, ChunkAccess chunk, Biome biome, int x, int z, int vHeight, int seaLevel) {
        int localX = x & 0xF;
        int localZ = z & 0xF;
        int topY = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, localZ);
        int westX = localX > 0 ? localX - 1 : localX;
        int eastX = localX < 15 ? localX + 1 : localX;
        int northZ = localZ > 0 ? localZ - 1 : localZ;
        int southZ = localZ < 15 ? localZ + 1 : localZ;
        int heightNorth = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, northZ);
        int heightSouth = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, southZ);
        int heightWest = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, westX, localZ);
        int heightEast = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, eastX, localZ);
        int slope = Math.max(Math.max(Math.abs(topY - heightNorth), Math.abs(topY - heightSouth)), Math.max(Math.abs(topY - heightWest), Math.abs(topY - heightEast)));
        if (this.profile == Profile.FOREST) {
            for (int d = 0; d <= 4 && topY - d >= 0; ++d) {
                if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            float soilNoise = this.smoothNoise(RandomSource.create((long)23874L), x, z, 0.1f);
            float mossNoise = this.smoothNoise(RandomSource.create((long)57813L), x + 17, z - 43, 0.15f);
            float podzolNoise = this.smoothNoise(RandomSource.create((long)98723L), x - 23, z + 61, 0.09f);
            for (int y = 0; y <= topY; ++y) {
                if (y != topY) continue;
                BlockState state = column.getBlock(y);
                if (slope >= 3 && state.is(Blocks.STONE)) {
                    int r = this.mixIndex(x, y, z);
                    if (r < 40) {
                        column.setBlock(y, Blocks.STONE.defaultBlockState());
                        continue;
                    }
                    if (r < 70) {
                        column.setBlock(y, Blocks.COBBLESTONE.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.MOSSY_COBBLESTONE.defaultBlockState());
                    continue;
                }
                if (soilNoise > 0.9f) {
                    column.setBlock(y, Blocks.MOSS_BLOCK.defaultBlockState());
                    continue;
                }
                if (podzolNoise > 0.8f) {
                    column.setBlock(y, Blocks.PODZOL.defaultBlockState());
                    continue;
                }
                if (soilNoise > 0.7f) {
                    column.setBlock(y, Blocks.ROOTED_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (mossNoise < 0.25f && slope >= 3) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.BIRCH_FOREST) {
            for (int d = 0; d <= 4 && topY - d >= 0; ++d) {
                if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            float soilNoise = this.smoothNoise(RandomSource.create((long)41237L), x, z, 0.08f);
            float lightSoilNoise = this.smoothNoise(RandomSource.create((long)71991L), x + 31, z - 17, 0.11f);
            for (int y = 0; y <= topY; ++y) {
                if (y != topY) continue;
                BlockState state = column.getBlock(y);
                if (slope >= 3 && state.is(Blocks.STONE)) {
                    int r = this.mixIndex(x, y, z);
                    if (r < 40) {
                        column.setBlock(y, Blocks.STONE.defaultBlockState());
                        continue;
                    }
                    if (r < 75) {
                        column.setBlock(y, Blocks.COBBLESTONE.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.MOSSY_COBBLESTONE.defaultBlockState());
                    continue;
                }
                if (soilNoise > 0.82f) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (lightSoilNoise > 0.75f) {
                    column.setBlock(y, Blocks.ROOTED_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.OLD_GROWTH_BIRCH_FOREST) {
            for (int d = 0; d <= 4 && topY - d >= 0; ++d) {
                if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            int period = 10;
            int bandA = Math.floorMod((x >> 1) + (z >> 1) * 2, period);
            int bandB = Math.floorMod(x + z >> 1, period);
            int bandC = Math.floorMod(x - z >> 1, period);
            boolean longBand = bandA <= 2 || bandB <= 1 || bandC <= 1;
            float gate = this.smoothNoise(RandomSource.create((long)64231L), x - 37, z + 19, 0.03f);
            float breakUp = this.smoothNoise(RandomSource.create((long)91217L), x + 11, z - 23, 0.085f);
            float packedMudNoise = this.smoothNoise(RandomSource.create((long)33121L), x - 7, z + 5, 0.05f);
            float patchAmplify = this.smoothNoise(RandomSource.create((long)77177L), x + 83, z - 41, 0.028f);
            boolean enabled = gate > 0.76f && breakUp > 0.34f;
            for (int y = 0; y <= topY; ++y) {
                boolean inPatch;
                if (y != topY) continue;
                if (slope >= 3) {
                    column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                    continue;
                }
                boolean bl = inPatch = longBand && enabled && packedMudNoise + patchAmplify * 0.5f > 0.64f || packedMudNoise > 0.88f;
                if (inPatch) {
                    int mix = this.mixIndex(x, y, z);
                    if (packedMudNoise > 0.76f && mix >= 65) {
                        column.setBlock(y, Blocks.PACKED_MUD.defaultBlockState());
                        if (y - 1 < 0) continue;
                        column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                        continue;
                    }
                    if (mix < 72) {
                        column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                        if (y - 1 < 0) continue;
                        column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.ROOTED_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.STONY_SHORE) {
            int y;
            int topSurfaceY;
            int waterTopY;
            int bedrockY = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, localX, localZ);
            for (waterTopY = topSurfaceY = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, localZ); waterTopY > bedrockY && column.getBlock(waterTopY).getFluidState().is(FluidTags.WATER); --waterTopY) {
            }
            boolean hasWater = waterTopY < topSurfaceY && column.getBlock(waterTopY + 1).getFluidState().is(FluidTags.WATER);
            int underwaterTop = hasWater ? Math.min(waterTopY, bedrockY + 3) : bedrockY - 1;
            int landTopY = hasWater ? waterTopY : topSurfaceY;
            float soilMask = this.smoothNoise(RandomSource.create((long)66111L), x - 21, z + 7, 0.035f);
            float soilDetail = this.smoothNoise(RandomSource.create((long)77441L), x + 9, z - 13, 0.11f);
            boolean sparseSoil = soilMask > 0.83f && soilDetail > 0.56f;
            for (y = bedrockY; y <= underwaterTop; ++y) {
                boolean replaceable;
                BlockState state = column.getBlock(y);
                boolean belowWater = column.getBlock(y + 1).getFluidState().is(FluidTags.WATER) || column.getBlock(y).getFluidState().is(FluidTags.WATER);
                boolean bl = replaceable = state.is(Blocks.STONE) || state.is(Blocks.DIRT) || state.is(Blocks.GRAVEL) || state.is(Blocks.SAND) || state.is(Blocks.CLAY);
                if (!belowWater || !replaceable) continue;
                int mix = this.mixIndex(x, y, z);
                if (mix < 40) {
                    column.setBlock(y, Blocks.MOSSY_COBBLESTONE.defaultBlockState());
                    continue;
                }
                if (mix < 52) {
                    column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.STONE.defaultBlockState());
            }
            for (y = 0; y <= landTopY; ++y) {
                if (y != landTopY) continue;
                if (slope >= 3) {
                    int mix = this.mixIndex(x, y, z);
                    if (mix < 8) {
                        column.setBlock(y, Blocks.MOSSY_COBBLESTONE.defaultBlockState());
                        continue;
                    }
                    if (mix < 30) {
                        column.setBlock(y, Blocks.COBBLESTONE.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.STONE.defaultBlockState());
                    continue;
                }
                if (sparseSoil) {
                    int soilMix = this.mixIndex(x, y, z);
                    if (soilMix < 65) {
                        column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                        if (y - 1 < 0) continue;
                        column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                    continue;
                }
                int surfaceMix = this.mixIndex(x, y, z);
                if (surfaceMix < 6) {
                    column.setBlock(y, Blocks.MOSSY_COBBLESTONE.defaultBlockState());
                    continue;
                }
                if (surfaceMix < 26) {
                    column.setBlock(y, Blocks.COBBLESTONE.defaultBlockState());
                    continue;
                }
                if (surfaceMix < 34) {
                    column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.STONE.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.RIVER) {
            int topSurfaceY;
            int waterTopY;
            int bedrockY = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, localX, localZ);
            for (waterTopY = topSurfaceY = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, localZ); waterTopY > bedrockY && column.getBlock(waterTopY).getFluidState().is(FluidTags.WATER); --waterTopY) {
            }
            boolean hasWater = waterTopY < topSurfaceY && column.getBlock(waterTopY + 1).getFluidState().is(FluidTags.WATER);
            int maxDepth = hasWater ? 3 : 0;
            float bedNoise = this.smoothNoise(RandomSource.create((long)31117L), x, z, 0.11f);
            float pocketNoise = this.smoothNoise(RandomSource.create((long)17171L), x + 41, z - 33, 0.12f);
            int waterFloorY = hasWater ? bedrockY : topSurfaceY;
            int underwaterTop = hasWater ? Math.min(waterTopY - 1, bedrockY + maxDepth) : bedrockY - 1;
            for (int y = waterFloorY; y <= underwaterTop; ++y) {
                boolean steep;
                BlockState state = column.getBlock(y);
                boolean replaceable = state.is(Blocks.STONE) || state.is(Blocks.DIRT) || state.is(Blocks.GRAVEL) || state.is(Blocks.SAND);
                boolean belowWater = column.getBlock(y + 1).getFluidState().is(FluidTags.WATER) || state.getFluidState().is(FluidTags.WATER);
                boolean bl = steep = slope >= 3;
                if (!replaceable || !belowWater || y - 1 < 0 || column.getBlock(y - 1).isAir()) continue;
                if (state.is(Blocks.STONE)) {
                    int chance = Math.floorMod(this.mixIndex(x, y, z), 100);
                    if (chance < 30) {
                        int mix = Math.floorMod(this.mixIndex(x, y + 11, z - 7), 100);
                        if (mix < 20) {
                            column.setBlock(y, ((Block)ObjectRegistry.MOSSY_TRAVERTIN.get()).defaultBlockState());
                        } else if (mix < 60) {
                            column.setBlock(y, ((Block)ObjectRegistry.TRAVERTIN.get()).defaultBlockState());
                        } else {
                            column.setBlock(y, ((Block)ObjectRegistry.COBBLED_TRAVERTIN.get()).defaultBlockState());
                        }
                    } else if (bedNoise > 0.75f && y <= bedrockY + 1) {
                        column.setBlock(y, Blocks.CLAY.defaultBlockState());
                    } else if (bedNoise > 0.7f && y <= bedrockY + 1) {
                        column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
                    } else if (steep && bedNoise > 0.55f) {
                        column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
                    }
                } else if (bedNoise > 0.75f && y <= bedrockY + 1) {
                    column.setBlock(y, Blocks.CLAY.defaultBlockState());
                } else if (bedNoise > 0.7f && y <= bedrockY + 1) {
                    column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
                }
                if (!column.getBlock(y).is(Blocks.SAND)) continue;
                column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
            }
            int bankTopY = hasWater ? waterTopY : topSurfaceY;
            int bankStartY = Math.max(bedrockY, bankTopY - 2);
            int bankEndY = Math.min(topSurfaceY, bankTopY + 1);
            boolean warmBiome = biome.getBaseTemperature() > 0.8f;
            for (int y = bankStartY; y <= bankEndY; ++y) {
                boolean replaceable;
                BlockState state = column.getBlock(y);
                boolean nearWater = y + 1 <= topSurfaceY && column.getBlock(y + 1).getFluidState().is(FluidTags.WATER) || state.getFluidState().is(FluidTags.WATER);
                boolean bl = replaceable = state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.DIRT) || state.is(Blocks.COARSE_DIRT) || state.is(Blocks.GRAVEL) || state.is(Blocks.SAND);
                if (!nearWater || !replaceable) continue;
                int choice = Math.floorMod(this.mixIndex(x, y, z), 100);
                if (warmBiome && choice < 6) {
                    column.setBlock(y, Blocks.SAND.defaultBlockState());
                    continue;
                }
                if (choice < 58) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
            }
            if (!hasWater) {
                boolean groundOk;
                BlockState ground = column.getBlock(topSurfaceY);
                boolean bl = groundOk = ground.is(Blocks.GRASS_BLOCK) || ground.is(Blocks.DIRT) || ground.is(Blocks.SAND) || ground.is(Blocks.GRAVEL);
                if (groundOk && pocketNoise > 0.82f && slope >= 2) {
                    column.setBlock(topSurfaceY, Blocks.GRAVEL.defaultBlockState());
                    if (topSurfaceY - 1 >= 0 && !column.getBlock(topSurfaceY - 1).getFluidState().is(FluidTags.WATER)) {
                        column.setBlock(topSurfaceY - 1, Blocks.DIRT.defaultBlockState());
                    }
                }
            }
            return;
        }
        if (this.profile == Profile.DARK_FOREST) {
            for (int d = 0; d <= 4 && topY - d >= 0; ++d) {
                if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            float mudGate = this.smoothNoise(RandomSource.create((long)88421L), x - 31, z + 77, 0.03f);
            float mudShapeA = this.smoothNoise(RandomSource.create((long)22119L), x + 9, z - 13, 0.065f);
            float mudShapeB = this.smoothNoise(RandomSource.create((long)99131L), x - 47, z + 21, 0.055f);
            boolean mudEnabled = mudGate > 0.82f && (mudShapeA + mudShapeB) * 0.5f > 0.58f;
            float podzolNoise = this.smoothNoise(RandomSource.create((long)56771L), x + 33, z - 11, 0.09f);
            float darkSoilNoise = this.smoothNoise(RandomSource.create((long)33551L), x - 19, z + 27, 0.12f);
            float mycelNoise = this.smoothNoise(RandomSource.create((long)71237L), x + 61, z + 5, 0.045f);
            for (int y = 0; y <= topY; ++y) {
                if (y != topY) continue;
                BlockState state = column.getBlock(y);
                if (slope >= 3 && state.is(Blocks.STONE)) {
                    int r = this.mixIndex(x, y, z);
                    if (r < 30) {
                        column.setBlock(y, Blocks.MOSSY_COBBLESTONE.defaultBlockState());
                        continue;
                    }
                    if (r < 70) {
                        column.setBlock(y, Blocks.COBBLESTONE.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.STONE.defaultBlockState());
                    continue;
                }
                if (mudEnabled) {
                    column.setBlock(y, Blocks.MUD.defaultBlockState());
                    int h = 1 + Math.floorMod(this.mixIndex(x, y, z), 3);
                    for (int d = 1; d <= 3 && y - d >= 0; ++d) {
                        int gate = this.mixIndex(x, y - d, z);
                        if (d <= h && gate > 18) {
                            column.setBlock(y - d, ((Block)ObjectRegistry.MARSH_BLOCK.get()).defaultBlockState());
                            continue;
                        }
                        column.setBlock(y - d, Blocks.DIRT.defaultBlockState());
                    }
                    continue;
                }
                if (podzolNoise > 0.78f) {
                    column.setBlock(y, Blocks.PODZOL.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (darkSoilNoise > 0.72f) {
                    int soilMix = this.mixIndex(x, y, z);
                    if (soilMix < 60) {
                        column.setBlock(y, Blocks.PODZOL.defaultBlockState());
                    } else {
                        column.setBlock(y, Blocks.ROOTED_DIRT.defaultBlockState());
                    }
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (mycelNoise > 0.88f) {
                    column.setBlock(y, Blocks.MYCELIUM.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.PLAINS) {
            for (int d = 0; d <= 4 && topY - d >= 0; ++d) {
                if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            float mask = this.smoothNoise(RandomSource.create((long)912345L), x - 113, z + 271, 0.02f);
            float n1 = this.smoothNoise(RandomSource.create((long)34187L), x, z, 0.08f);
            float warpA = this.smoothNoise(RandomSource.create((long)87777L), x - 113, z + 271, 0.03f) * 6.0f;
            float warpB = this.smoothNoise(RandomSource.create((long)12341L), x + 47, z - 31, 0.07f) * 2.5f;
            float patchNoise = this.smoothNoise(RandomSource.create((long)44417L), x + (int)warpA, z + (int)warpB, 0.028f);
            float detailNoise = this.smoothNoise(RandomSource.create((long)90123L), x, z, 0.085f);
            boolean inPatch = patchNoise > 0.74f && detailNoise > 0.45f;
            for (int y = 0; y <= topY; ++y) {
                if (y != topY) continue;
                if (slope >= 3) {
                    column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                    continue;
                }
                if (inPatch) {
                    int mix = this.mixIndex(x, y, z);
                    if (mix < 90) {
                        column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                        if (y - 1 < 0) continue;
                        column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.ROOTED_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (mask <= 0.7f) {
                    column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                    continue;
                }
                if (n1 > 0.85f) {
                    column.setBlock(y, Blocks.ROOTED_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (n1 > 0.7f) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
            }
            return;
        }
        for (int d = 0; d <= 4 && topY - d >= 0; ++d) {
            if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
            return;
        }
        for (int y = 0; y <= topY; ++y) {
            if (y != topY) continue;
            column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
        }
    }

    private int mixIndex(int x, int y, int z) {
        long seed = (long)x * 341873128712L + (long)y * 132897987541L + (long)z * 42317861L;
        return RandomSource.create((long)seed).nextInt(100);
    }

    private float smoothNoise(RandomSource random, int x, int z, float scale) {
        float xf = (float)x * scale;
        float zf = (float)z * scale;
        int xi = (int)Math.floor(xf);
        int zi = (int)Math.floor(zf);
        float tx = xf - (float)xi;
        float tz = zf - (float)zi;
        random.setSeed((long)xi * 49632L + (long)zi * 325176L);
        float c = random.nextFloat();
        random.setSeed((long)(xi + 1) * 49632L + (long)zi * 325176L);
        float e = random.nextFloat();
        random.setSeed((long)xi * 49632L + (long)(zi + 1) * 325176L);
        float s = random.nextFloat();
        random.setSeed((long)(xi + 1) * 49632L + (long)(zi + 1) * 325176L);
        float se = random.nextFloat();
        float i1 = this.lerp(c, e, tx);
        float i2 = this.lerp(s, se, tx);
        return this.lerp(i1, i2, tz);
    }

    private float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public static void registerSurfaceRules() {
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("river"), (BiolithSurfaceBuilder)new TemperateSurfaceBuilder(Profile.RIVER).setBiomeKey(Biomes.RIVER));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("forest"), (BiolithSurfaceBuilder)new TemperateSurfaceBuilder(Profile.FOREST).setBiomeKey(Biomes.FOREST));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("plains"), (BiolithSurfaceBuilder)new TemperateSurfaceBuilder(Profile.PLAINS).setBiomeKey(Biomes.PLAINS));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("sunflower_plains"), (BiolithSurfaceBuilder)new TemperateSurfaceBuilder(Profile.PLAINS).setBiomeKey(Biomes.SUNFLOWER_PLAINS));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("birch_forest"), (BiolithSurfaceBuilder)new TemperateSurfaceBuilder(Profile.BIRCH_FOREST).setBiomeKey(Biomes.BIRCH_FOREST));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("old_growth_birch_forest"), (BiolithSurfaceBuilder)new TemperateSurfaceBuilder(Profile.OLD_GROWTH_BIRCH_FOREST).setBiomeKey(Biomes.OLD_GROWTH_BIRCH_FOREST));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("stony_shore"), (BiolithSurfaceBuilder)new TemperateSurfaceBuilder(Profile.STONY_SHORE).setBiomeKey(Biomes.STONY_SHORE));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("dark_forest"), (BiolithSurfaceBuilder)new TemperateSurfaceBuilder(Profile.DARK_FOREST).setBiomeKey(Biomes.DARK_FOREST));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("aspen_forest"), (BiolithSurfaceBuilder)new TemperateSurfaceBuilder(Profile.OLD_GROWTH_BIRCH_FOREST).setBiomeKey(BloomingNatureBiomeKeys.ASPEN_FOREST));
    }

    public static enum Profile {
        RIVER,
        FOREST,
        PLAINS,
        BIRCH_FOREST,
        OLD_GROWTH_BIRCH_FOREST,
        STONY_SHORE,
        DARK_FOREST;

    }
}

