/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.biome.wet;

import com.terraformersmc.biolith.api.biome.BiomePlacement;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.api.biome.sub.CriterionBuilder;
import com.terraformersmc.biolith.api.biome.sub.RatioTargets;
import com.terraformersmc.biolith.api.surface.BiolithSurfaceBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;
import net.satisfy.bloomingnature.core.world.biome.BloomingNatureBiomeKeys;

public final class WetBiomeRegistry
extends BiolithSurfaceBuilder {
    public static void registerBiomePlacement() {
        WetBiomeRegistry.registerJungleRiverPlacement();
        WetBiomeRegistry.registerMarshlandPlacement();
    }

    private static void registerJungleRiverPlacement() {
        Criterion nearJungle = CriterionBuilder.anyOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor((ResourceKey)Biomes.JUNGLE), CriterionBuilder.neighbor((ResourceKey)Biomes.SPARSE_JUNGLE), CriterionBuilder.neighbor((ResourceKey)Biomes.BAMBOO_JUNGLE)});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.RIVER, BloomingNatureBiomeKeys.JUNGLE_RIVER, (Criterion)nearJungle);
        Criterion riverTouch = CriterionBuilder.neighbor((ResourceKey)Biomes.RIVER);
        Criterion edgeBand = CriterionBuilder.ratio((RatioTargets)RatioTargets.EDGE, (float)0.35f, (float)1.0f);
        Criterion condEdge = CriterionBuilder.allOf((Criterion[])new Criterion[]{riverTouch, edgeBand});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.JUNGLE, BloomingNatureBiomeKeys.JUNGLE_RIVER, (Criterion)condEdge);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.SPARSE_JUNGLE, BloomingNatureBiomeKeys.JUNGLE_RIVER, (Criterion)condEdge);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.BAMBOO_JUNGLE, BloomingNatureBiomeKeys.JUNGLE_RIVER, (Criterion)condEdge);
    }

    private static void registerMarshlandPlacement() {
        Criterion nearWet = CriterionBuilder.anyOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor((ResourceKey)Biomes.SWAMP), CriterionBuilder.neighbor((ResourceKey)Biomes.MANGROVE_SWAMP)});
        Criterion edgeZone = CriterionBuilder.ratio((RatioTargets)RatioTargets.EDGE, (float)0.0f, (float)0.55f);
        Criterion cond = CriterionBuilder.allOf((Criterion[])new Criterion[]{nearWet, edgeZone});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.SWAMP, BloomingNatureBiomeKeys.MARSHLAND, (Criterion)cond);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.MANGROVE_SWAMP, BloomingNatureBiomeKeys.MARSHLAND, (Criterion)cond);
    }
}

