/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.biome.wet.surface;

import com.terraformersmc.biolith.api.surface.BiolithSurfaceBuilder;
import com.terraformersmc.biolith.api.surface.SurfaceGeneration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.satisfy.bloomingnature.BloomingNature;
import net.satisfy.bloomingnature.core.registry.ObjectRegistry;
import net.satisfy.bloomingnature.core.world.biome.BloomingNatureBiomeKeys;

public final class WetSurfaceBuilder
extends BiolithSurfaceBuilder {
    private final Profile profile;

    public WetSurfaceBuilder(Profile profile) {
        this.profile = profile;
    }

    public void generate(BiomeManager biomeManager, BlockColumn column, RandomSource random, ChunkAccess chunk, Biome biome, int x, int z, int vHeight, int seaLevel) {
        int waterTop;
        int localX = x & 0xF;
        int localZ = z & 0xF;
        int topY = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, localZ);
        int floorY = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, localX, localZ);
        int westX = localX > 0 ? localX - 1 : localX;
        int eastX = localX < 15 ? localX + 1 : localX;
        int northZ = localZ > 0 ? localZ - 1 : localZ;
        int southZ = localZ < 15 ? localZ + 1 : localZ;
        int heightNorth = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, northZ);
        int heightSouth = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, localX, southZ);
        int heightWest = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, westX, localZ);
        int heightEast = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, eastX, localZ);
        int slope = Math.max(Math.max(Math.abs(topY - heightNorth), Math.abs(topY - heightSouth)), Math.max(Math.abs(topY - heightWest), Math.abs(topY - heightEast)));
        if (this.profile == Profile.SWAMP) {
            for (int d = 0; d <= 3 && topY - d >= 0; ++d) {
                if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            float baseNoise = this.smoothNoise(RandomSource.create((long)712345L), x + 17, z - 29, 0.032f);
            float bandNoise = this.smoothNoise(RandomSource.create((long)398721L), x - 41, z + 63, 0.085f);
            float dryness = this.saturate((baseNoise - 0.4f) / 0.4f);
            float band = this.saturate((bandNoise - 0.35f) / 0.45f);
            boolean isSteep = slope >= 4;
            for (int y = 0; y <= topY; ++y) {
                if (y != topY) continue;
                if (isSteep) {
                    if (band < 0.35f) {
                        column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                    } else if (band < 0.75f) {
                        column.setBlock(y, Blocks.MUD.defaultBlockState());
                    } else {
                        column.setBlock(y, Blocks.MUD.defaultBlockState());
                    }
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (dryness < 0.35f) {
                    column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                    continue;
                }
                if (dryness < 0.7f) {
                    if (band < 0.5f) {
                        column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.MUD.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (band < 0.5f) {
                    column.setBlock(y, Blocks.MUD.defaultBlockState());
                } else {
                    column.setBlock(y, Blocks.MUD.defaultBlockState());
                }
                if (y - 1 < 0) continue;
                column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.SPARSE_JUNGLE) {
            for (int d = 0; d <= 3 && topY - d >= 0; ++d) {
                if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            float baseNoise = this.smoothNoise(RandomSource.create((long)712345L), x + 17, z - 29, 0.032f);
            float bandNoise = this.smoothNoise(RandomSource.create((long)398721L), x - 41, z + 63, 0.085f);
            float dryness = this.saturate((baseNoise - 0.4f) / 0.4f);
            float band = this.saturate((bandNoise - 0.35f) / 0.45f);
            boolean isSteep = slope >= 4;
            for (int y = 0; y <= topY; ++y) {
                if (y != topY) continue;
                if (isSteep) {
                    if (band < 0.35f) {
                        column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                    } else if (band < 0.75f) {
                        column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    } else {
                        column.setBlock(y, Blocks.MUD.defaultBlockState());
                    }
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (dryness < 0.35f) {
                    column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                    continue;
                }
                if (dryness < 0.7f) {
                    if (band < 0.5f) {
                        column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (band < 0.5f) {
                    column.setBlock(y, Blocks.MUD.defaultBlockState());
                } else {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                }
                if (y - 1 < 0) continue;
                column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
            }
            return;
        }
        if (this.profile == Profile.JUNGLE) {
            int chance;
            for (int d = 0; d <= 4 && topY - d >= 0; ++d) {
                if (!column.getBlock(topY - d).getFluidState().is(FluidTags.WATER)) continue;
                return;
            }
            float maskLow = this.smoothNoise(RandomSource.create((long)912345L), x - 113, z + 271, 0.018f);
            float maskHigh = this.smoothNoise(RandomSource.create((long)34187L), x + 31, z - 47, 0.045f);
            float detail = this.smoothNoise(RandomSource.create((long)90123L), x, z, 0.095f);
            float bandBase = this.saturate((maskLow - 0.5f) / 0.28f);
            float bandDetail = this.saturate((maskHigh - 0.4f) / 0.35f);
            float wetFactor = bandBase * 0.65f + bandDetail * 0.35f;
            wetFactor *= this.saturate((detail - 0.35f) / 0.4f);
            boolean isSteep = slope >= 3;
            boolean isFoot = isSteep && topY <= seaLevel + 2;
            for (int y = 0; y <= topY; ++y) {
                if (y != topY) continue;
                if (isSteep) {
                    if (isFoot) {
                        float footNoise = this.smoothNoise(RandomSource.create((long)55123L), x, z, 0.12f);
                        if (footNoise < 0.5f) {
                            column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                            continue;
                        }
                        column.setBlock(y, Blocks.GRAVEL.defaultBlockState());
                        continue;
                    }
                    column.setBlock(y, ((Block)ObjectRegistry.LATERIT.get()).defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, ((Block)ObjectRegistry.LATERIT.get()).defaultBlockState());
                    continue;
                }
                if (wetFactor <= 0.18f) {
                    column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                    continue;
                }
                if (wetFactor <= 0.45f) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                if (wetFactor <= 0.78f) {
                    column.setBlock(y, Blocks.MOSS_BLOCK.defaultBlockState());
                    if (y - 1 < 0) continue;
                    column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.MUD.defaultBlockState());
                if (y - 1 < 0) continue;
                column.setBlock(y - 1, Blocks.DIRT.defaultBlockState());
            }
            if (wetFactor > 0.72f && slope <= 2 && (chance = x * 734287 + z * 912931 & 0xF) < 7) {
                int marshY;
                int depthRange = 2 + chance % 6;
                for (int d = 0; d < depthRange && (marshY = topY - d) >= floorY && (column.getBlock(marshY).is(Blocks.MUD) || column.getBlock(marshY).is(Blocks.DIRT) || column.getBlock(marshY).is(Blocks.COARSE_DIRT) || column.getBlock(marshY).is(Blocks.GRASS_BLOCK) || column.getBlock(marshY).is(Blocks.MOSS_BLOCK) || column.getBlock(marshY).is((Block)ObjectRegistry.MARSH_BLOCK.get())); ++d) {
                    column.setBlock(marshY, ((Block)ObjectRegistry.MARSH_BLOCK.get()).defaultBlockState());
                }
            }
            int maxDepth = Math.max(8, topY - floorY);
            for (int y = topY; y >= floorY; --y) {
                if (!column.getBlock(y).is(Blocks.STONE)) continue;
                int depthFromTop = topY - y;
                if (depthFromTop <= 6) {
                    column.setBlock(y, ((Block)ObjectRegistry.LATERIT.get()).defaultBlockState());
                    continue;
                }
                if (depthFromTop <= maxDepth) {
                    column.setBlock(y, Blocks.TUFF.defaultBlockState());
                    continue;
                }
                column.setBlock(y, Blocks.TUFF.defaultBlockState());
            }
            return;
        }
        for (waterTop = topY; waterTop > floorY && column.getBlock(waterTop).getFluidState().is(FluidTags.WATER); --waterTop) {
        }
        boolean hasWater = waterTop < topY && column.getBlock(waterTop + 1).getFluidState().is(FluidTags.WATER);
        int edgeGap = Math.max(Math.abs(topY - heightNorth), Math.max(Math.abs(topY - heightSouth), Math.max(Math.abs(topY - heightWest), Math.abs(topY - heightEast))));
        int ramp = Math.max(1, Math.min(4, edgeGap / 2));
        if (topY <= floorY) {
            return;
        }
        float noise = this.smoothNoise(random, x, z, 0.08f);
        boolean isSteepRiver = slope >= 3;
        boolean isShore = hasWater && topY <= seaLevel + ramp;
        int depth = 0;
        for (int y = topY; y >= floorY; --y) {
            if (column.getBlock(y).isAir()) {
                if (depth <= 0) continue;
                break;
            }
            if (column.getBlock(y).is(Blocks.WATER)) {
                depth = 0;
                continue;
            }
            if (depth == 0) {
                if (isShore) {
                    if (isSteepRiver) {
                        column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                    } else {
                        column.setBlock(y, Blocks.MUD.defaultBlockState());
                    }
                } else if (isSteepRiver) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                } else if (noise > 0.6f) {
                    column.setBlock(y, Blocks.MOSS_BLOCK.defaultBlockState());
                } else if (noise < 0.3f) {
                    column.setBlock(y, Blocks.COARSE_DIRT.defaultBlockState());
                } else {
                    column.setBlock(y, Blocks.GRASS_BLOCK.defaultBlockState());
                }
            } else {
                if (depth >= 3) break;
                column.setBlock(y, Blocks.DIRT.defaultBlockState());
            }
            ++depth;
        }
    }

    private float smoothNoise(RandomSource random, int x, int z, float scale) {
        float xf = (float)x * scale;
        float zf = (float)z * scale;
        int xi = (int)Math.floor(xf);
        int zi = (int)Math.floor(zf);
        float tx = xf - (float)xi;
        float tz = zf - (float)zi;
        random.setSeed((long)xi * 49632L + (long)zi * 325176L);
        float c = random.nextFloat();
        random.setSeed((long)(xi + 1) * 49632L + (long)zi * 325176L);
        float e = random.nextFloat();
        random.setSeed((long)xi * 49632L + (long)(zi + 1) * 325176L);
        float s = random.nextFloat();
        random.setSeed((long)(xi + 1) * 49632L + (long)(zi + 1) * 325176L);
        float se = random.nextFloat();
        float i1 = c + (e - c) * tx;
        float i2 = s + (se - s) * tx;
        return this.lerp(i1, i2, tz);
    }

    private float saturate(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        return Math.min(value, 1.0f);
    }

    private float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public static void registerSurfaceRules() {
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("jungle"), (BiolithSurfaceBuilder)new WetSurfaceBuilder(Profile.JUNGLE).setBiomeKey(Biomes.JUNGLE));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("sparse_jungle"), (BiolithSurfaceBuilder)new WetSurfaceBuilder(Profile.SPARSE_JUNGLE).setBiomeKey(Biomes.SPARSE_JUNGLE));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("jungle_river"), (BiolithSurfaceBuilder)new WetSurfaceBuilder(Profile.JUNGLE_RIVER).setBiomeKey(BloomingNatureBiomeKeys.JUNGLE_RIVER));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("swamp"), (BiolithSurfaceBuilder)new WetSurfaceBuilder(Profile.JUNGLE_RIVER).setBiomeKey(Biomes.SWAMP));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("marshland_river"), (BiolithSurfaceBuilder)new WetSurfaceBuilder(Profile.JUNGLE_RIVER).setBiomeKey(BloomingNatureBiomeKeys.MARSHLAND));
        SurfaceGeneration.addSurfaceBuilder((ResourceLocation)BloomingNature.identifier("marshland_sparse"), (BiolithSurfaceBuilder)new WetSurfaceBuilder(Profile.SWAMP).setBiomeKey(BloomingNatureBiomeKeys.MARSHLAND));
    }

    public static enum Profile {
        JUNGLE,
        JUNGLE_RIVER,
        SPARSE_JUNGLE,
        SWAMP;

    }
}

