/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.feature.configured.decoration;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.satisfy.bloomingnature.core.world.feature.configured.decoration.FallenHollowTrunkConfiguration;

public class FallenHollowTrunkFeature
extends Feature<FallenHollowTrunkConfiguration> {
    public FallenHollowTrunkFeature(Codec<FallenHollowTrunkConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<FallenHollowTrunkConfiguration> context) {
        BlockPos lateral;
        WorldGenLevel level = context.level();
        FallenHollowTrunkConfiguration config = (FallenHollowTrunkConfiguration)context.config();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        int length = config.length();
        boolean rotated = random.nextBoolean();
        BlockPos mainStep = rotated ? new BlockPos(0, 0, 1) : new BlockPos(1, 0, 0);
        BlockPos blockPos = lateral = rotated ? new BlockPos(1, 0, 0) : new BlockPos(0, 0, 1);
        if (random.nextBoolean()) {
            lateral = lateral.multiply(-1);
        }
        boolean breakStart = random.nextBoolean();
        boolean breakEnd = random.nextBoolean();
        for (int i = 0; i < length; ++i) {
            int baseX = origin.getX() + mainStep.getX() * i;
            int baseZ = origin.getZ() + mainStep.getZ() * i;
            int lateralShift = random.nextFloat() < 0.4f ? (random.nextBoolean() ? 1 : -1) : 0;
            int fx = baseX + lateral.getX() * lateralShift;
            int fz = baseZ + lateral.getZ() * lateralShift;
            int y = level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, fx, fz);
            BlockPos center = new BlockPos(fx, y - random.nextInt(2), fz);
            boolean broken = i == 0 && breakStart || i == length - 1 && breakEnd;
            this.placeShell((LevelAccessor)level, center, random, config, broken);
        }
        return true;
    }

    private void placeShell(LevelAccessor level, BlockPos center, RandomSource random, FallenHollowTrunkConfiguration config, boolean broken) {
        BlockPos t;
        BlockPos t2;
        BlockState log = config.log();
        BlockState moss = config.moss();
        BlockState mushBrown = Blocks.BROWN_MUSHROOM.defaultBlockState();
        BlockState mushRed = Blocks.RED_MUSHROOM.defaultBlockState();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                boolean wall;
                BlockPos p = center.offset(dx, 0, dz);
                boolean bl = wall = Math.abs(dx) + Math.abs(dz) > 0;
                if (wall) {
                    BlockPos top;
                    if (broken && random.nextFloat() < 0.4f) {
                        level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
                        continue;
                    }
                    BlockState chosen = random.nextFloat() < 0.25f ? moss : log;
                    level.setBlock(p, chosen, 3);
                    if (!config.vegetation() || !(random.nextFloat() < 0.1f) || !level.getBlockState(top = p.above()).isAir()) continue;
                    level.setBlock(top, moss, 3);
                    continue;
                }
                level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        if (config.brown() && random.nextFloat() < 0.04f && level.getBlockState(t2 = center.above()).isAir()) {
            level.setBlock(t2, mushBrown, 3);
        }
        if (config.red() && random.nextFloat() < 0.02f && level.getBlockState(t = center.above()).isAir()) {
            level.setBlock(t, mushRed, 3);
        }
    }
}

