/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.feature.configured.rock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public record RockPileFeatureConfig(int spreadX, int spreadZ, int minCount, int maxCount, List<RockSpec> rocks) implements FeatureConfiguration
{
    public static final Codec<RockPileFeatureConfig> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("spread_x").forGetter(RockPileFeatureConfig::spreadX), (App)Codec.INT.fieldOf("spread_z").forGetter(RockPileFeatureConfig::spreadZ), (App)Codec.INT.fieldOf("min_count").forGetter(RockPileFeatureConfig::minCount), (App)Codec.INT.fieldOf("max_count").forGetter(RockPileFeatureConfig::maxCount), (App)RockSpec.CODEC.listOf().fieldOf("rocks").forGetter(RockPileFeatureConfig::rocks)).apply((Applicative)i, RockPileFeatureConfig::new));

    public record RockSpec(BlockStateProvider stateProvider, int minSizeX, int maxSizeX, int minSizeY, int maxSizeY, int minSizeZ, int maxSizeZ, int minBury, int maxBury, float minRoughness, float maxRoughness) {
        public static final Codec<RockSpec> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockStateProvider.CODEC.fieldOf("state_provider").forGetter(RockSpec::stateProvider), (App)Codec.INT.fieldOf("min_size_x").forGetter(RockSpec::minSizeX), (App)Codec.INT.fieldOf("max_size_x").forGetter(RockSpec::maxSizeX), (App)Codec.INT.fieldOf("min_size_y").forGetter(RockSpec::minSizeY), (App)Codec.INT.fieldOf("max_size_y").forGetter(RockSpec::maxSizeY), (App)Codec.INT.fieldOf("min_size_z").forGetter(RockSpec::minSizeZ), (App)Codec.INT.fieldOf("max_size_z").forGetter(RockSpec::maxSizeZ), (App)Codec.INT.fieldOf("min_bury").forGetter(RockSpec::minBury), (App)Codec.INT.fieldOf("max_bury").forGetter(RockSpec::maxBury), (App)Codec.FLOAT.fieldOf("min_roughness").forGetter(RockSpec::minRoughness), (App)Codec.FLOAT.fieldOf("max_roughness").forGetter(RockSpec::maxRoughness)).apply((Applicative)i, RockSpec::new));

        private int pick(RandomSource r, int a, int b) {
            if (a >= b) {
                return a;
            }
            return a + r.nextInt(b - a + 1);
        }

        public int pickSizeX(RandomSource r) {
            return this.pick(r, this.minSizeX, this.maxSizeX);
        }

        public int pickSizeY(RandomSource r) {
            return this.pick(r, this.minSizeY, this.maxSizeY);
        }

        public int pickSizeZ(RandomSource r) {
            return this.pick(r, this.minSizeZ, this.maxSizeZ);
        }

        public int pickBury(RandomSource r) {
            return this.pick(r, this.minBury, this.maxBury);
        }

        public float pickRoughness(RandomSource r) {
            if (this.minRoughness >= this.maxRoughness) {
                return this.minRoughness;
            }
            return this.minRoughness + r.nextFloat() * (this.maxRoughness - this.minRoughness);
        }

        public BlockState state(RandomSource r, BlockPos pos) {
            return this.stateProvider.getState(r, pos);
        }
    }
}

