/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.feature.configured.tree.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.satisfy.bloomingnature.core.registry.PlacerTypeRegistry;
import org.jetbrains.annotations.NotNull;

public final class MushroomDecorator
extends TreeDecorator {
    public static final MapCodec<MushroomDecorator> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(0.18f)).forGetter(d -> Float.valueOf(d.chance)), (App)Codec.INT.fieldOf("min_y_offset").orElse((Object)0).forGetter(d -> d.minYOffset), (App)Codec.INT.fieldOf("max_y_offset").orElse((Object)4).forGetter(d -> d.maxYOffset), (App)Codec.INT.fieldOf("max_radius").orElse((Object)1).forGetter(d -> d.maxRadius), (App)Codec.INT.fieldOf("max_thickness").orElse((Object)2).forGetter(d -> d.maxThickness), (App)BlockStateProvider.CODEC.fieldOf("block_provider").orElse((Object)BlockStateProvider.simple((Block)Blocks.BROWN_MUSHROOM_BLOCK)).forGetter(d -> d.provider)).apply((Applicative)i, MushroomDecorator::new));
    private final float chance;
    private final int minYOffset;
    private final int maxYOffset;
    private final int maxRadius;
    private final int maxThickness;
    private final BlockStateProvider provider;

    public MushroomDecorator(float chance, int minYOffset, int maxYOffset, int maxRadius, int maxThickness, BlockStateProvider provider) {
        this.chance = chance;
        this.minYOffset = Math.max(0, minYOffset);
        this.maxYOffset = Math.max(this.minYOffset, maxYOffset);
        this.maxRadius = Math.max(1, maxRadius);
        this.maxThickness = Math.max(1, maxThickness);
        this.provider = provider;
    }

    @NotNull
    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)PlacerTypeRegistry.MUSHROOM_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        int baseY = context.logs().stream().mapToInt(Vec3i::getY).min().orElse(Integer.MAX_VALUE);
        int span = Math.max(0, this.maxYOffset - this.minYOffset);
        int targetOffset = this.minYOffset + (span == 0 ? 0 : random.nextInt(span + 1));
        for (BlockPos logPos : context.logs()) {
            if (logPos.getY() - baseY != targetOffset || random.nextFloat() >= this.chance) continue;
            Direction facing = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            int radius = 1 + random.nextInt(this.maxRadius);
            int thickness = 1 + random.nextInt(this.maxThickness);
            BlockState mushroomState = this.provider.getState(random, logPos);
            BlockPos attachPos = logPos.relative(facing);
            if (!context.isAir(attachPos)) continue;
            this.placeShelf(context, attachPos, facing, radius, thickness, mushroomState);
            break;
        }
    }

    private void placeShelf(TreeDecorator.Context context, BlockPos base, Direction facing, int radius, int thickness, BlockState state) {
        RandomSource random = context.random();
        Direction widthAxis = facing.getAxis() == Direction.Axis.X ? Direction.NORTH : Direction.WEST;
        for (int w = -radius; w <= radius; ++w) {
            double mask = (double)(w * w) / (double)(radius * radius);
            if (mask > 1.0) continue;
            for (int t = 0; t < thickness; ++t) {
                BlockPos p = base.relative(widthAxis, w).relative(facing, t);
                if (!context.isAir(p) || context.logs().contains((Object)p) || random.nextFloat() < 0.12f) continue;
                context.setBlock(p, state);
            }
        }
    }
}

