/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.feature.configured.tree.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.satisfy.bloomingnature.core.registry.PlacerTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class CypressFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<CypressFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(i -> CypressFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)i).and((App)IntProvider.codec((int)0, (int)24).fieldOf("trunk_height").forGetter(p -> p.trunkDrop)).apply((Applicative)i, CypressFoliagePlacer::new));
    private final IntProvider trunkDrop;

    public CypressFoliagePlacer(IntProvider layerRadius, IntProvider layerOffset, IntProvider trunkHeight) {
        super(layerRadius, layerOffset);
        this.trunkDrop = trunkHeight;
    }

    @NotNull
    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)PlacerTypeRegistry.CYPRESS_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int radius, int topOffset) {
        BlockPos anchor = attachment.pos();
        BlockPos.MutableBlockPos pos = anchor.mutable();
        int[] radii = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1};
        int layers = radii.length;
        int endY = topOffset - (layers - 1);
        for (int y = topOffset; y >= endY; --y) {
            int dy = topOffset - y;
            int ringRadius = radii[dy];
            if (ringRadius == 0) {
                pos.setWithOffset((Vec3i)anchor, 0, y, 0);
                CypressFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                if (dy > 2 || random.nextInt(5) != 0) continue;
                Direction d1 = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                Direction d2 = random.nextBoolean() ? d1.getClockWise() : d1.getCounterClockWise();
                CypressFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos.relative(d1, 1).relative(d2, 1));
                continue;
            }
            this.placeRing(level, setter, random, config, anchor, ringRadius, y, attachment.doubleTrunk(), dy, random);
        }
    }

    private void placeRing(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos center, int ringRadius, int relY, boolean doubleTrunk, int layerIndex, RandomSource rng) {
        boolean forceCardinals;
        int inflate = doubleTrunk ? 1 : 0;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        boolean thin = ringRadius == 1;
        boolean mid = ringRadius == 2;
        boolean bl = forceCardinals = layerIndex <= 6;
        int skipOdds = thin ? 5 : (mid ? 7 : 8);
        for (int dx = -ringRadius; dx <= ringRadius + inflate; ++dx) {
            for (int dz = -ringRadius; dz <= ringRadius + inflate; ++dz) {
                boolean isCardinal;
                int az;
                int ax;
                if (dx == 0 && dz == 0 || (float)((ax = Math.abs(dx)) * ax + (az = Math.abs(dz)) * az) > ((float)ringRadius + 0.25f) * ((float)ringRadius + 0.25f)) continue;
                boolean bl2 = isCardinal = ax + az == 1;
                if (!forceCardinals ? (thin ? isCardinal && rng.nextInt(skipOdds + 1) == 0 || ax == 1 && az == 1 && rng.nextInt(skipOdds + 2) == 0 : (mid ? (ax == ringRadius || az == ringRadius) && rng.nextInt(skipOdds + 1) == 0 : ax == ringRadius && az == ringRadius || rng.nextInt(skipOdds + 3) == 0)) : !isCardinal && thin && rng.nextInt(skipOdds + 2) == 0) continue;
                p.setWithOffset((Vec3i)center, dx, relY, dz);
                CypressFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)p);
            }
        }
    }

    public int foliageHeight(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return 14;
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean doubleTrunk) {
        return false;
    }
}

