/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.feature.configured.tree.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.satisfy.bloomingnature.core.registry.PlacerTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class TaigaFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<TaigaFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> TaigaFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and((App)IntProvider.codec((int)0, (int)24).fieldOf("trunk_height").forGetter(placer -> placer.trunkHeight)).apply((Applicative)instance, TaigaFoliagePlacer::new));
    private final IntProvider trunkHeight;

    public TaigaFoliagePlacer(IntProvider radius, IntProvider offset, IntProvider trunkHeight) {
        super(radius, offset);
        this.trunkHeight = trunkHeight;
    }

    @NotNull
    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)PlacerTypeRegistry.TAIGA_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(@NotNull LevelSimulatedReader level, @NotNull FoliagePlacer.FoliageSetter setter, @NotNull RandomSource random, @NotNull TreeConfiguration config, int trunkHeight, @NotNull FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int radius, int topOffset) {
        BlockPos anchor = attachment.pos();
        BlockPos.MutableBlockPos mutablePos = anchor.mutable();
        int[] radii = new int[]{0, 0, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 2, 2, 1};
        int layers = radii.length;
        int topEnd = --topOffset - (layers - 1);
        for (int y = topOffset; y >= topEnd; --y) {
            int layerIndex = topOffset - y;
            int ringRadius = radii[layerIndex];
            if (ringRadius == 0) {
                mutablePos.setWithOffset((Vec3i)anchor, 0, y, 0);
                TaigaFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutablePos);
                if (layerIndex > 2 || random.nextInt(4) != 0) continue;
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                Direction secondDirection = random.nextBoolean() ? direction.getClockWise() : direction.getCounterClockWise();
                TaigaFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutablePos.relative(direction, 1).relative(secondDirection, 1));
                continue;
            }
            this.placeRing(level, setter, random, config, anchor, ringRadius, y, attachment.doubleTrunk(), layerIndex, random);
        }
        int radiusStep = random.nextInt(2);
        int maxRadius = 1;
        int previousRadius = 0;
        int bottomLimit = -2;
        int lowestRelativeY = Math.max(-foliageHeight, bottomLimit);
        for (int relativeY = topEnd - 1; relativeY >= lowestRelativeY; --relativeY) {
            this.placeLeavesRow(level, setter, random, config, anchor, radiusStep, relativeY, attachment.doubleTrunk());
            if (radiusStep >= maxRadius) {
                radiusStep = previousRadius;
                previousRadius = 1;
                maxRadius = Math.min(maxRadius + 1, radius + attachment.radiusOffset());
                continue;
            }
            ++radiusStep;
        }
    }

    private void placeRing(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos center, int ringRadius, int relativeY, boolean doubleTrunk, int layerIndex, RandomSource rng) {
        boolean forceCardinals;
        int inflate = doubleTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean thinRing = ringRadius == 1;
        boolean midRing = ringRadius == 2;
        boolean bl = forceCardinals = layerIndex <= 4;
        int skipOdds = thinRing ? 4 : (midRing ? 6 : 7);
        for (int offsetX = -ringRadius; offsetX <= ringRadius + inflate; ++offsetX) {
            for (int offsetZ = -ringRadius; offsetZ <= ringRadius + inflate; ++offsetZ) {
                boolean cardinal;
                boolean nearTrunk;
                int absZ;
                int absX;
                if (offsetX == 0 && offsetZ == 0 || (float)((absX = Math.abs(offsetX)) * absX + (absZ = Math.abs(offsetZ)) * absZ) > ((float)ringRadius + 0.25f) * ((float)ringRadius + 0.25f)) continue;
                boolean bl2 = nearTrunk = absX <= 1 && absZ <= 1;
                if (nearTrunk) {
                    mutablePos.setWithOffset((Vec3i)center, offsetX, relativeY, offsetZ);
                    TaigaFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutablePos);
                    continue;
                }
                boolean bl3 = cardinal = absX + absZ == 1;
                if (!forceCardinals ? (thinRing ? cardinal && rng.nextInt(skipOdds + 1) == 0 || absX == 1 && absZ == 1 && rng.nextInt(skipOdds + 2) == 0 : (midRing ? (absX == ringRadius || absZ == ringRadius) && rng.nextInt(skipOdds + 1) == 0 : absX == ringRadius && absZ == ringRadius || rng.nextInt(skipOdds + 2) == 0)) : !cardinal && thinRing && rng.nextInt(skipOdds + 2) == 0) continue;
                mutablePos.setWithOffset((Vec3i)center, offsetX, relativeY, offsetZ);
                TaigaFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutablePos);
            }
        }
    }

    public int foliageHeight(@NotNull RandomSource random, int height, @NotNull TreeConfiguration config) {
        int sampled = height - this.trunkHeight.sample(random);
        return Math.max(4, sampled - 2);
    }

    protected boolean shouldSkipLocation(@NotNull RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && range > 0;
    }
}

