/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.feature.configured.tree.trunk;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.satisfy.bloomingnature.core.registry.PlacerTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class CrookedTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<CrookedTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(builder -> CrookedTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, CrookedTrunkPlacer::new));

    public CrookedTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)PlacerTypeRegistry.CROOKED_TRUNK_PLACER.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        BlockPos.MutableBlockPos mutable = pos.mutable();
        this.placeLog(level, blockSetter, random, mutable.relative(direction.getOpposite()), config, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
        this.placeLog(level, blockSetter, random, mutable.relative(random.nextInt(2) == 0 ? direction.getClockWise() : direction.getCounterClockWise()), config);
        for (int i = 0; i < freeTreeHeight; ++i) {
            if (random.nextFloat() < 0.4f && i > 2) {
                mutable.move(direction);
            }
            this.placeLog(level, blockSetter, random, (BlockPos)mutable, config);
            mutable.move(Direction.UP);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment((BlockPos)mutable, 0, false));
    }
}

