/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.feature.configured.tree.trunk;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.satisfy.bloomingnature.core.registry.PlacerTypeRegistry;

public class TallGiantTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<TallGiantTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> TallGiantTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and((App)Codec.intRange((int)0, (int)16).fieldOf("extra_height").forGetter(placer -> placer.extraHeight)).apply((Applicative)instance, TallGiantTrunkPlacer::new));
    private final int extraHeight;

    public TallGiantTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, int extraHeight) {
        super(baseHeight, heightRandA, heightRandB);
        this.extraHeight = extraHeight;
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)PlacerTypeRegistry.TALL_GIANT_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader levelReader, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource randomSource, int trunkHeight, BlockPos startPos, TreeConfiguration configuration) {
        int y;
        BlockPos groundPos = startPos.below();
        TallGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)levelReader, blockSetter, (RandomSource)randomSource, (BlockPos)groundPos, (TreeConfiguration)configuration);
        TallGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)levelReader, blockSetter, (RandomSource)randomSource, (BlockPos)groundPos.east(), (TreeConfiguration)configuration);
        TallGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)levelReader, blockSetter, (RandomSource)randomSource, (BlockPos)groundPos.south(), (TreeConfiguration)configuration);
        TallGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)levelReader, blockSetter, (RandomSource)randomSource, (BlockPos)groundPos.south().east(), (TreeConfiguration)configuration);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int mainHeight = trunkHeight;
        int totalHeight = mainHeight + this.extraHeight;
        for (y = 0; y < mainHeight; ++y) {
            this.placeLogIfFreeWithOffset(levelReader, blockSetter, randomSource, mutablePos, configuration, startPos, 0, y, 0);
            if (y >= mainHeight - 1) continue;
            this.placeLogIfFreeWithOffset(levelReader, blockSetter, randomSource, mutablePos, configuration, startPos, 1, y, 0);
            this.placeLogIfFreeWithOffset(levelReader, blockSetter, randomSource, mutablePos, configuration, startPos, 1, y, 1);
            this.placeLogIfFreeWithOffset(levelReader, blockSetter, randomSource, mutablePos, configuration, startPos, 0, y, 1);
        }
        for (y = mainHeight; y < totalHeight; ++y) {
            this.placeLogIfFreeWithOffset(levelReader, blockSetter, randomSource, mutablePos, configuration, startPos, 0, y, 0);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(startPos.above(totalHeight), 0, true));
    }

    private void placeLogIfFreeWithOffset(LevelSimulatedReader levelReader, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource randomSource, BlockPos.MutableBlockPos mutablePos, TreeConfiguration configuration, BlockPos startPos, int offsetX, int offsetY, int offsetZ) {
        mutablePos.setWithOffset((Vec3i)startPos, offsetX, offsetY, offsetZ);
        this.placeLogIfFree(levelReader, blockSetter, randomSource, mutablePos, configuration);
    }
}

