/*
 * Decompiled with CFR 0.152.
 */
package thetestmod.bettercrates.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import thetestmod.bettercrates.container.ContainerBase13Rows;
import thetestmod.bettercrates.container.ContainerBase9Rows;
import thetestmod.bettercrates.enums.EnumCrate;
import thetestmod.bettercrates.tile.TileEntityBase;

public class BaseCrate
extends Block
implements EntityBlock {
    private final EnumCrate enumCrate;

    public BaseCrate(EnumCrate enumCrate) {
        super(BlockBehaviour.Properties.of().strength(3.0f, enumCrate.getResistance()));
        this.enumCrate = enumCrate;
        enumCrate.setBlock(this);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider(this.getContainerProvider(pos), (Component)Component.translatable((String)this.enumCrate.getTransKey())), buf -> buf.writeBlockPos(pos).writeInt(this.enumCrate.ordinal()));
        return InteractionResult.CONSUME;
    }

    private MenuConstructor getContainerProvider(BlockPos pos) {
        if (this.enumCrate.ordinal() >= 5) {
            return (id, playerInv, player) -> new ContainerBase13Rows(id, playerInv, pos, this.enumCrate);
        }
        return (id, playerInv, player) -> new ContainerBase9Rows(id, playerInv, pos, this.enumCrate);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.enumCrate.getSupplier().create(blockPos, blockState);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity te = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (te instanceof TileEntityBase) {
            ItemStack stack = new ItemStack((ItemLike)Item.byBlock((Block)this));
            te.saveToItem(stack, (HolderLookup.Provider)builder.getLevel().registryAccess());
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            result.add(stack);
            return result;
        }
        return super.getDrops(state, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"item.crate_base.tooltip"));
    }
}

