/*
 * Decompiled with CFR 0.152.
 */
package thetestmod.bettercrates.items;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import thetestmod.bettercrates.tile.TileEntityBase;

public class ItemUpgradeBase
extends Item {
    private Block block;
    private BlockState state;

    public ItemUpgradeBase(Block block, BlockState state) {
        super(new Item.Properties());
        this.block = block;
        this.state = state;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity te;
        if (!context.getLevel().isClientSide && context.getLevel().getBlockState(context.getClickedPos()).getBlock() == this.block && (te = context.getLevel().getBlockEntity(context.getClickedPos())) != null) {
            CompoundTag tag = new CompoundTag();
            NonNullList<ItemStack> inventory = te instanceof ChestBlockEntity ? ((ChestBlockEntity)te).items : ((TileEntityBase)te).getInv();
            ContainerHelper.saveAllItems((CompoundTag)tag, inventory, (HolderLookup.Provider)context.getLevel().registryAccess());
            inventory.clear();
            context.getLevel().setBlock(context.getClickedPos(), this.state, context.getLevel().isClientSide ? 11 : 3);
            TileEntityBase teNew = (TileEntityBase)context.getLevel().getBlockEntity(context.getClickedPos());
            ContainerHelper.loadAllItems((CompoundTag)tag, teNew.getInv(), (HolderLookup.Provider)context.getLevel().registryAccess());
            context.getItemInHand().shrink(1);
            context.getPlayer().playSound(SoundEvents.ENDER_CHEST_OPEN, 1.0f, 1.0f);
            context.getLevel().playSound(null, context.getClickedPos(), SoundEvents.ANVIL_PLACE, SoundSource.PLAYERS, 0.4f, 0.8f);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
        tooltip.add((Component)Component.translatable((String)"item.up.tooltip_base"));
    }
}

