/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.item;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.net.BlockConfigRequestMessage;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import dev.ftb.mods.ftbquests.registry.ModItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TaskScreenConfiguratorItem
extends Item {
    public TaskScreenConfiguratorItem() {
        super(ModItems.defaultProps());
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (level.getBlockEntity(ctx.getClickedPos()) instanceof ITaskScreen) {
                TaskScreenConfiguratorItem.storeBlockPos(ctx.getItemInHand(), ctx.getLevel(), ctx.getClickedPos());
                ctx.getPlayer().level().playSound(null, ctx.getClickedPos(), (SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ctx.getPlayer().displayClientMessage((Component)Component.translatable((String)"ftbquests.message.configurator_bound", (Object[])new Object[]{TaskScreenConfiguratorItem.posToString(ctx.getClickedPos())}), true);
            } else {
                return this.tryUseOn(sp, ctx.getItemInHand()) ? InteractionResult.CONSUME : InteractionResult.FAIL;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            return this.tryUseOn(sp, stack) ? InteractionResultHolder.consume((Object)stack) : InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        if (context.registries() != null) {
            list.add((Component)Component.translatable((String)"item.ftbquests.task_screen_configurator.tooltip").withStyle(ChatFormatting.GRAY));
            TaskScreenConfiguratorItem.readBlockPos(itemStack).ifPresent(gPos -> {
                String str = String.valueOf(gPos.dimension().location()) + " / " + TaskScreenConfiguratorItem.posToString(gPos.pos());
                list.add((Component)Component.translatable((String)"ftbquests.message.configurator_bound", (Object[])new Object[]{str}).withStyle(ChatFormatting.DARK_AQUA));
            });
        }
    }

    private boolean tryUseOn(ServerPlayer player, ItemStack stack) {
        return TaskScreenConfiguratorItem.readBlockPos(stack).map(gPos -> {
            ServerLevel level = player.getServer().getLevel(gPos.dimension());
            if (level != player.level() || !player.level().isLoaded(gPos.pos())) {
                player.displayClientMessage((Component)Component.translatable((String)"ftbquests.message.task_screen_inaccessible").withStyle(ChatFormatting.RED), true);
                return false;
            }
            BlockEntity patt0$temp = level.getBlockEntity(gPos.pos());
            if (patt0$temp instanceof ITaskScreen) {
                ITaskScreen taskScreen = (ITaskScreen)patt0$temp;
                if (taskScreen.hasPermissionToEdit((Player)player)) {
                    taskScreen.getCoreScreen().ifPresent(coreScreen -> NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BlockConfigRequestMessage(coreScreen.getBlockPos(), BlockConfigRequestMessage.BlockType.TASK_SCREEN)));
                    return true;
                }
                player.displayClientMessage((Component)Component.translatable((String)"block.ftbquests.screen.no_permission").withStyle(ChatFormatting.RED), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"ftbquests.message.missing_task_screen").withStyle(ChatFormatting.RED), true);
            }
            return false;
        }).orElse(false);
    }

    public static void storeBlockPos(ItemStack stack, Level level, BlockPos clickedPos) {
        stack.set((DataComponentType)ModDataComponents.SCREEN_POS.get(), (Object)GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)clickedPos));
    }

    public static Optional<GlobalPos> readBlockPos(ItemStack stack) {
        return FTBQuests.getComponent(stack, ModDataComponents.SCREEN_POS);
    }

    private static String posToString(BlockPos pos) {
        return String.format("[%d,%d,%d]", pos.getX(), pos.getY(), pos.getZ());
    }
}

