/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record BlockConfigRequestMessage(BlockPos pos, BlockType blockType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BlockConfigRequestMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("block_config_request_message"));
    public static final StreamCodec<FriendlyByteBuf, BlockConfigRequestMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BlockConfigRequestMessage::pos, (StreamCodec)NetworkHelper.enumStreamCodec(BlockType.class), BlockConfigRequestMessage::blockType, BlockConfigRequestMessage::new);

    public CustomPacketPayload.Type<BlockConfigRequestMessage> type() {
        return TYPE;
    }

    public static void handle(BlockConfigRequestMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            switch (message.blockType.ordinal()) {
                case 0: {
                    FTBQuestsClient.openTaskScreenConfigGui(message.pos);
                    break;
                }
                case 1: {
                    FTBQuestsClient.openBarrierConfigGui(message.pos);
                }
            }
        });
    }

    public static enum BlockType {
        TASK_SCREEN,
        BARRIER;

    }
}

