/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.net.EditObjectResponseMessage;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;

public record EditObjectMessage(long id, CompoundTag nbt) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EditObjectMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("edit_object_message"));
    public static final StreamCodec<FriendlyByteBuf, EditObjectMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, EditObjectMessage::id, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, EditObjectMessage::nbt, EditObjectMessage::new);

    public static EditObjectMessage forQuestObject(QuestObjectBase qo) {
        FTBQuests.getRecipeModHelper().refreshRecipes(qo);
        ClientQuestFile.INSTANCE.clearCachedData();
        return new EditObjectMessage(qo.id, (CompoundTag)Util.make((Object)new CompoundTag(), nbt1 -> qo.writeData((CompoundTag)nbt1, ClientQuestFile.INSTANCE.holderLookup())));
    }

    public static void sendToServer(QuestObjectBase qo) {
        NetworkManager.sendToServer((CustomPacketPayload)EditObjectMessage.forQuestObject(qo));
    }

    public CustomPacketPayload.Type<EditObjectMessage> type() {
        return TYPE;
    }

    public static void handle(EditObjectMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            QuestObjectBase object;
            if (NetUtils.canEdit(context) && (object = ServerQuestFile.INSTANCE.getBase(message.id)) != null) {
                object.readData(message.nbt, (HolderLookup.Provider)context.registryAccess());
                ServerQuestFile.INSTANCE.clearCachedData();
                ServerQuestFile.INSTANCE.markDirty();
                NetworkHelper.sendToAll((MinecraftServer)context.getPlayer().getServer(), (CustomPacketPayload)new EditObjectResponseMessage(object));
                object.editedFromGUIOnServer();
            }
        });
    }
}

