/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import ht.treechop.client.model.ModelUtil;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.tuber.math.Vector3;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class ChoppedLogBakedModel
implements UnbakedModel,
BakedModel {
    private static TextureAtlasSprite defaultSprite;
    protected static final ResourceLocation DEFAULT_TEXTURE_RESOURCE;
    public static final RenderType RENDER_TYPE;

    public static void setDefaultSprite(TextureAtlasSprite defaultSprite) {
        ChoppedLogBakedModel.defaultSprite = defaultSprite;
    }

    private static BlockState getStrippedNeighbor(BlockAndTintGetter level, BlockPos pos, Direction direction) {
        BlockPos neighborPos = pos.relative(direction);
        return ChopUtil.getStrippedState(level, pos, level.getBlockState(neighborPos));
    }

    protected static Map<Direction, BlockState> getStrippedNeighbors(BlockAndTintGetter level, BlockPos pos, ChoppedLogBlock.MyEntity entity) {
        if (entity.getOriginalState().isSolidRender((BlockGetter)level, pos)) {
            return entity.streamSolidSides((BlockGetter)level, pos).collect(Collectors.toMap(side -> side, side -> ChoppedLogBakedModel.getStrippedNeighbor(level, pos, side)));
        }
        return Collections.emptyMap();
    }

    protected List<BakedQuad> getBlockQuads(BlockState blockState, Direction side, RandomSource rand) {
        BakedModel model = ChoppedLogBakedModel.getBlockModel(blockState);
        return model.getQuads(blockState, side, rand);
    }

    @NotNull
    public static BakedModel getBlockModel(BlockState blockState) {
        ModelResourceLocation modelLocation = BlockModelShaper.stateToModelLocation((BlockState)blockState);
        return Minecraft.getInstance().getModelManager().getModel(modelLocation);
    }

    @NotNull
    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> function) {
    }

    public BakedModel bake(@NotNull ModelBaker modelBakery, Function<Material, TextureAtlasSprite> textureGetter, @NotNull ModelState modelState) {
        defaultSprite = textureGetter.apply(new Material(TextureAtlas.LOCATION_BLOCKS, DEFAULT_TEXTURE_RESOURCE));
        return this;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction direction, @NotNull RandomSource randomSource) {
        return Collections.emptyList();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.getDefaultSprite();
    }

    @NotNull
    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    protected TextureAtlasSprite getDefaultSprite() {
        return defaultSprite;
    }

    protected Stream<BakedQuad> getQuads(BlockState strippedState, ChoppedLogShape shape, int radius, RandomSource random, Map<Direction, BlockState> strippedNeighbors) {
        Direction[] allDirections = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, null};
        AABB box = shape.getBoundingBox(radius);
        Vector3 mins = new Vector3(box.minX, box.minY, box.minZ);
        Vector3 maxes = new Vector3(box.maxX, box.maxY, box.maxZ);
        return Stream.concat(Arrays.stream(allDirections).flatMap(side -> this.getBlockQuads(strippedState, (Direction)side, random).stream().map(quad -> ModelUtil.trimQuad(quad, mins, maxes))), strippedNeighbors.entrySet().stream().flatMap(entry -> {
            Direction side = (Direction)entry.getKey();
            BlockState strippedNeighbor = (BlockState)entry.getValue();
            Vec3i normal = side.getNormal().multiply(16);
            Vector3 transform = new Vector3(normal.getX(), normal.getY(), normal.getZ());
            return ChoppedLogBakedModel.getBlockModel(strippedNeighbor).getQuads(strippedNeighbor, side.getOpposite(), random).stream().map(quad -> ModelUtil.translateQuad(quad, transform));
        })).filter(Objects::nonNull);
    }

    static {
        DEFAULT_TEXTURE_RESOURCE = ResourceLocation.withDefaultNamespace((String)"block/stripped_oak_log");
        RENDER_TYPE = RenderType.cutout();
    }
}

