/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.api.ChopEvent;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.util.TickUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(modid="treechop", bus=EventBusSubscriber.Bus.MOD)
public class NoChopRecursion {
    private static final Map<Player, Long> lastChopTickByPlayers = new HashMap<Player, Long>();

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        if (((Boolean)ConfigHandler.COMMON.preventChopRecursion.get()).booleanValue()) {
            NeoForge.EVENT_BUS.register(EventHandler.class);
        }
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onChop(ChopEvent.StartChopEvent event) {
            Player agent = event.getPlayer();
            long time = event.getLevel().getGameTime();
            if (lastChopTickByPlayers.getOrDefault(agent, TickUtil.NEVER) == time) {
                event.setCanceled(true);
            } else {
                lastChopTickByPlayers.put(agent, time);
            }
        }
    }
}

