/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests;

import java.util.List;
import java.util.function.Supplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import shetiphian.enderchests.Configs;

final class ConfigLoader {
    ConfigLoader(ModContainer modContainer, IEventBus modEventBus) {
        ModConfigSpec.Builder client_builder = new ModConfigSpec.Builder();
        ModConfigSpec.Builder common_builder = new ModConfigSpec.Builder();
        Configs.GENERAL.inWorldRecoloring.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.GENERAL.fullStackLinking.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        client_builder.comment(Configs.GUI_STYLE.COMMENT).push(Configs.GUI_STYLE.ID);
        Configs.GUI_STYLE.enderchest.wrap(config -> client_builder.defineEnum(config.getKey(), (Enum)((Configs.Menu_GUI.STYLE)((Object)((Object)config.getDefault())))));
        client_builder.pop();
        Supplier<String> newEntry = () -> "<modId>:<item> or tag|<tagId>";
        common_builder.comment(Configs.UPGRADE_ITEMS.COMMENT).push(Configs.UPGRADE_ITEMS.ID);
        Configs.UPGRADE_ITEMS.convertToPersonal.wrap(config -> common_builder.defineListAllowEmpty(config.getKey(), (List)config.getDefault(), newEntry, config.validator()));
        Configs.UPGRADE_ITEMS.convertToTeam.wrap(config -> common_builder.defineListAllowEmpty(config.getKey(), (List)config.getDefault(), newEntry, config.validator()));
        Configs.UPGRADE_ITEMS.sCapacity_multi.wrap(config -> common_builder.defineListAllowEmpty(config.getKey(), (List)config.getDefault(), newEntry, config.validator()));
        Configs.UPGRADE_ITEMS.lCapacity_multi.wrap(config -> common_builder.defineListAllowEmpty(config.getKey(), (List)config.getDefault(), newEntry, config.validator()));
        Configs.UPGRADE_ITEMS.sCapacity_single.wrap(config -> common_builder.defineListAllowEmpty(config.getKey(), (List)config.getDefault(), newEntry, config.validator()));
        Configs.UPGRADE_ITEMS.lCapacity_single.wrap(config -> common_builder.defineListAllowEmpty(config.getKey(), (List)config.getDefault(), newEntry, config.validator()));
        common_builder.pop();
        common_builder.comment(Configs.UPGRADE_SETTINGS.COMMENT).push(Configs.UPGRADE_SETTINGS.ID);
        Configs.UPGRADE_SETTINGS.chestSizeMin.wrap(config -> common_builder.defineInRange(config.getKey(), ((Integer)config.getDefault()).intValue(), ((Integer)config.min()).intValue(), ((Integer)config.max()).intValue()), this::updater);
        Configs.UPGRADE_SETTINGS.chestSizeMax.wrap(config -> common_builder.defineInRange(config.getKey(), ((Integer)config.getDefault()).intValue(), ((Integer)config.min()).intValue(), ((Integer)config.max()).intValue()), this::updater);
        common_builder.pop();
        common_builder.comment(Configs.ACCESS_SETTINGS.COMMENT).push(Configs.ACCESS_SETTINGS.ID);
        Configs.ACCESS_SETTINGS.allowEnderPouch.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.allowPublicChests.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.allowPersonalChests.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.allowTeamChests.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.allowPublicBags.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.allowPersonalBags.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.allowTeamBags.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.enableAutomationPublic.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.enableAutomationPersonal.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.enableAutomationTeam.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.lockPersonalEdit.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.lockTeamEdit.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.lockPersonalLink.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.lockTeamLink.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.lockPersonalUse.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        Configs.ACCESS_SETTINGS.lockTeamUse.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        common_builder.pop();
        client_builder.comment(Configs.COLOR_VALUES.COMMENT).push(Configs.COLOR_VALUES.ID);
        Configs.COLOR_VALUES.white.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.orange.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.magenta.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.light_blue.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.yellow.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.lime.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.pink.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.gray.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.light_gray.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.cyan.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.purple.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.blue.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.brown.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.green.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.red.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        Configs.COLOR_VALUES.black.wrap(config -> client_builder.translation(config.langKey()).define(config.getKey(), (Object)((String)config.getDefault()), config.validator()));
        client_builder.pop();
        client_builder.comment(Configs.INTEGRATION.COMMENT).push(Configs.INTEGRATION.ID);
        Configs.INTEGRATION.enableCurios.wrap(config -> common_builder.define(config.getKey(), ((Boolean)config.getDefault()).booleanValue()));
        client_builder.pop();
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)client_builder.build(), "enderchests-client.toml");
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)common_builder.build(), "enderchests.toml");
        modEventBus.addListener(this::onLoad);
        modEventBus.addListener(this::onReLoad);
    }

    private <T> void updater(ModConfigSpec.ConfigValue<T> config, T value) {
        try {
            config.set(value);
            config.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void process(ModConfig config) {
        if (config.getType() == ModConfig.Type.CLIENT) {
            Configs.process_client();
        }
        if (config.getType() == ModConfig.Type.COMMON) {
            Configs.process_common();
        }
    }

    private void onLoad(ModConfigEvent.Loading event) {
        this.process(event.getConfig());
    }

    private void onReLoad(ModConfigEvent.Reloading event) {
        this.process(event.getConfig());
    }
}

