/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests;

import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.registries.DeferredRegister;
import shetiphian.enderchests.CreativeTabs;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.component.EnderNetwork;
import shetiphian.enderchests.common.crafting.EnderRecipe;
import shetiphian.enderchests.common.inventory.ContainerProviders;
import shetiphian.enderchests.common.item.ItemBlockEnderChest;
import shetiphian.enderchests.common.item.ItemEnderBag;
import shetiphian.enderchests.common.item.ItemEnderPouch;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;
import shetiphian.enderchests.modintegration.ModIntegration;

final class Registration {
    Registration(IEventBus eventBus) {
        this.dataComponents(this.create(Registries.DATA_COMPONENT_TYPE, eventBus));
        this.blocks(this.create((Registry)BuiltInRegistries.BLOCK, eventBus));
        this.tiles(this.create(BuiltInRegistries.BLOCK_ENTITY_TYPE, eventBus));
        this.items(this.create((Registry)BuiltInRegistries.ITEM, eventBus));
        this.recipes(this.create(BuiltInRegistries.RECIPE_TYPE, eventBus));
        this.recipeSerializers(this.create(BuiltInRegistries.RECIPE_SERIALIZER, eventBus));
        this.containers(this.create(BuiltInRegistries.MENU, eventBus));
        CreativeTabs.init(eventBus);
        eventBus.addListener(Registration::registerCapabilities);
    }

    private <T> DeferredRegister<T> create(Registry<T> registry, IEventBus eventBus) {
        return this.create(registry.key(), eventBus);
    }

    private <T> DeferredRegister<T> create(ResourceKey<? extends Registry<T>> key, IEventBus eventBus) {
        DeferredRegister registry = DeferredRegister.create(key, (String)"enderchests");
        registry.register(eventBus);
        return registry;
    }

    private void dataComponents(DeferredRegister<DataComponentType<?>> reg) {
        Roster.DataComponents.NETWORK.wrap(id -> reg.register(id, () -> DataComponentType.builder().persistent(EnderNetwork.CODEC).build()));
    }

    private void blocks(DeferredRegister<Block> reg) {
        Roster.Blocks.ENDERCHEST.wrap(id -> reg.register(id, BlockEnderChest::new));
    }

    private void tiles(DeferredRegister<BlockEntityType<?>> reg) {
        Roster.Tiles.ENDERCHEST.wrap(id -> reg.register(id, () -> BlockEntityType.Builder.of(TileEntityEnderChest::new, (Block[])new Block[]{(Block)Roster.Blocks.ENDERCHEST.get()}).build(null)));
    }

    private void items(DeferredRegister<Item> reg) {
        Roster.Items.ENDERCHEST.wrap(id -> reg.register(id, () -> new ItemBlockEnderChest((Block)Roster.Blocks.ENDERCHEST.get(), Registration.networkedItem())));
        Roster.Items.ENDERBAG.wrap(id -> reg.register(id, () -> new ItemEnderBag(Registration.networkedItem())));
        Roster.Items.ENDERPOUCH.wrap(id -> reg.register(id, () -> new ItemEnderPouch(Registration.stackable())));
    }

    private static Item.Properties networkedItem() {
        return Registration.stackable().component((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)EnderNetwork.DEFAULT);
    }

    private static Item.Properties stackable() {
        return new Item.Properties();
    }

    private void recipes(DeferredRegister<RecipeType<?>> reg) {
        Roster.Recipes.CRAFTING.wrap(id -> reg.register(id, () -> RecipeType.simple((ResourceLocation)EnderChests.RESOURCE.apply((String)id))));
    }

    private void recipeSerializers(DeferredRegister<RecipeSerializer<?>> reg) {
        Roster.RecipeSerializers.CRAFTING.wrap(id -> reg.register(id, EnderRecipe.Serializer::new));
    }

    private void containers(DeferredRegister<MenuType<?>> reg) {
        Roster.Containers.ENDER_BAG.wrap(id -> reg.register(id, () -> IMenuTypeExtension.create(ContainerProviders.EnderBag::createMenu)));
        Roster.Containers.ENDER_CHEST.wrap(id -> reg.register(id, () -> IMenuTypeExtension.create(ContainerProviders.EnderChest::createMenu)));
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Roster.Tiles.ENDERCHEST.get(), (tile, side) -> new InvWrapper((Container)tile.getInventory()));
        ModIntegration.INSTANCE.initCapabilities(event);
    }
}

