/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.block;

import com.google.common.base.Strings;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ToolHelper;
import shetiphian.core.common.block.IExtendedAwarenessBlock;
import shetiphian.core.common.inventory.MenuProviderWithData;
import shetiphian.core.platform.Services;
import shetiphian.enderchests.Configs;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.common.block.HitBoxHelper;
import shetiphian.enderchests.common.inventory.ContainerProviders;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.StackHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class BlockEnderChest
extends BaseEntityBlock
implements IColored,
IExtendedAwarenessBlock {
    private static final MapCodec<BlockEnderChest> CODEC = BlockEnderChest.simpleCodec(instance -> new BlockEnderChest());
    public static final BooleanProperty STATIC = BooleanProperty.create((String)"static");
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Direction[])Direction.values());
    private static final EnumProperty<EnumType> VARIANT = EnumProperty.create((String)"variant", EnumType.class);
    public static final HashMap<Direction, VoxelShape[]> SHAPES = new HashMap();
    private static final HashMap<Direction, VoxelShape[]> SHAPES2 = new HashMap();

    public MapCodec<BlockEnderChest> codec() {
        return CODEC;
    }

    public BlockEnderChest() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ENDER_CHEST).mapColor(MapColor.COLOR_BLACK).destroyTime(5.0f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)STATIC, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VARIANT, STATIC});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityEnderChest(pos, state);
    }

    private TileEntityEnderChest getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        return tile instanceof TileEntityEnderChest ? (TileEntityEnderChest)tile : null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (SHAPES.isEmpty()) {
            Map<Direction, VoxelShape> chest_body = HitBoxHelper.getBody();
            Map<Direction, VoxelShape> chest_lid = HitBoxHelper.getLid();
            Map<Direction, VoxelShape> top_ring = HitBoxHelper.getRing_Top();
            Map<Direction, VoxelShape> middle_ring = HitBoxHelper.getRing_Middle();
            Map<Direction, VoxelShape> bottom_ring = HitBoxHelper.getRing_Bottom();
            for (Direction direction : Direction.values()) {
                VoxelShape[] shapes = new VoxelShape[]{chest_body.getOrDefault(direction, Shapes.empty()), top_ring.getOrDefault(direction, Shapes.empty()), middle_ring.getOrDefault(direction, Shapes.empty()), bottom_ring.getOrDefault(direction, Shapes.empty()), chest_lid.getOrDefault(direction, Shapes.empty())};
                SHAPES.put(direction, shapes);
            }
        }
        if (!SHAPES.isEmpty()) {
            Direction direction = BlockEnderChest.getFacing(state);
            TileEntityEnderChest tile = this.getTile(world, pos);
            if (tile != null) {
                if (!SHAPES2.containsKey(direction)) {
                    VoxelShape base = SHAPES.get(direction)[0];
                    VoxelShape lid = SHAPES.get(direction)[4];
                    Vec3i vec = direction.getOpposite().getNormal();
                    VoxelShape[] shapes = new VoxelShape[11];
                    shapes[0] = Shapes.or((VoxelShape)base, (VoxelShape)lid);
                    for (int index = 1; index <= 10; ++index) {
                        double var = (double)index / 10.0 * (double)0.7f;
                        shapes[index] = Shapes.or((VoxelShape)base, (VoxelShape)lid.move((double)vec.getX() * var, (double)vec.getY() * var, (double)vec.getZ() * var));
                    }
                    SHAPES2.put(direction, shapes);
                }
                return SHAPES2.get(direction)[tile.getLidOffsetIndex()];
            }
            return SHAPES.get(direction)[0];
        }
        return Shapes.block();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult result = this.onBlockActivated(state, world, pos, player, player.getItemInHand(hand));
        return result == InteractionResult.SUCCESS ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult onBlockActivated(BlockState state, Level world, BlockPos pos, Player player, ItemStack heldItem) {
        TileEntityEnderChest chestTile = this.getTile((BlockGetter)world, pos);
        if (chestTile == null) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            if (heldItem.isEmpty() || !ToolHelper.isWrench((ItemStack)heldItem)) {
                BlockPos blockpos = pos.relative(BlockEnderChest.getFacing(state).getOpposite());
                if (player instanceof ServerPlayer && chestTile.canUse(player) && !world.getBlockState(blockpos).isRedstoneConductor((BlockGetter)world, blockpos)) {
                    Services.COMMON.openMenu(player, (MenuProviderWithData)ContainerProviders.EnderChest.create(chestTile));
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.isEmpty()) {
            DyeColor color;
            int subHit;
            if (chestTile.isPublic()) {
                boolean changed = false;
                if (Configs.PROCESSED.listPersonal.contains(heldItem.getItem())) {
                    if (((Boolean)Configs.ACCESS_SETTINGS.allowPersonalChests.get()).booleanValue()) {
                        changed = true;
                        chestTile.setOwner(player, heldItem.copy().split(1));
                        Helpers.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue(VARIANT, (Comparable)((Object)EnumType.PRIVATE))), (boolean)true);
                    } else {
                        ChestInfoHelper.sendError(player, "enderchests.chest.private.disabled");
                    }
                }
                if (!changed && Configs.PROCESSED.listTeam.contains(heldItem.getItem())) {
                    if (((Boolean)Configs.ACCESS_SETTINGS.allowTeamChests.get()).booleanValue()) {
                        String teamID = Helpers.getPlayerTeamID((Player)player);
                        if (!Strings.isNullOrEmpty((String)teamID)) {
                            changed = true;
                            chestTile.setOwner("#" + teamID, heldItem.copy().split(1));
                            Helpers.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue(VARIANT, (Comparable)((Object)EnumType.TEAM))), (boolean)true);
                        } else {
                            ChestInfoHelper.sendError(player, "shetiphian.team.noteam");
                        }
                    } else {
                        ChestInfoHelper.sendError(player, "enderchests.chest.team.disabled");
                    }
                }
                if (changed) {
                    if (!player.getAbilities().instabuild) {
                        heldItem.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            if (!chestTile.canEdit(player)) {
                return InteractionResult.SUCCESS;
            }
            short capacity = ChestHelper.getCapacity(world, chestTile.getOwnerID(), chestTile.getCode());
            if (capacity < Configs.PROCESSED.chestSizeMax.get()) {
                int newValue = 0;
                if (Configs.PROCESSED.listSmallCap_Single.contains(heldItem.getItem())) {
                    newValue = -1;
                    if (chestTile.applyItem(heldItem)) {
                        newValue = 3;
                    } else {
                        ChestInfoHelper.sendError(player, "enderchests.chest.upgrade_used");
                    }
                }
                if (newValue == 0 && Configs.PROCESSED.listSmallCap_Multi.contains(heldItem.getItem())) {
                    newValue = 3;
                }
                if (newValue == 0 && capacity + 9 <= Configs.PROCESSED.chestSizeMax.get()) {
                    if (Configs.PROCESSED.listLargeCap_Single.contains(heldItem.getItem())) {
                        newValue = -1;
                        if (chestTile.applyItem(heldItem)) {
                            newValue = 9;
                        } else {
                            ChestInfoHelper.sendError(player, "enderchests.chest.upgrade_used");
                        }
                    }
                    if (newValue == 0 && Configs.PROCESSED.listLargeCap_Multi.contains(heldItem.getItem())) {
                        newValue = 9;
                    }
                }
                if (newValue > 0) {
                    ChestHelper.setCapacity(world, chestTile.getOwnerID(), chestTile.getCode(), (byte)(capacity + newValue));
                    if (!player.getAbilities().instabuild) {
                        heldItem.shrink(1);
                    }
                    ChestInfoHelper.sendCapacityInfo(player, chestTile);
                    return InteractionResult.SUCCESS;
                }
            }
            if (((Boolean)Configs.GENERAL.inWorldRecoloring.get()).booleanValue() && (subHit = Helpers.getSubShapeHit((Entity)player, (BlockPos)pos, (VoxelShape[])SHAPES.get(state.getValue((Property)FACING)))) > 0 && subHit < 4 && (color = DyeHelper.getDyeColor((Item)heldItem.getItem())) != null && chestTile.doColorRing(color, player)) {
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                world.updateNeighborsAt(pos, (Block)this);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide() ? BlockEnderChest.createTickerHelper(type, (BlockEntityType)((BlockEntityType)Roster.Tiles.ENDERCHEST.get()), TileEntityEnderChest::tick) : null;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        TileEntityEnderChest tile = this.getTile(world, pos);
        if (tile != null && tile.canEdit(player, false)) {
            return super.getDestroyProgress(state, player, world, pos);
        }
        return -1.0f;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityEnderChest tile = this.getTile((BlockGetter)world, pos);
        if (tile != null) {
            tile.setCode(StackHelper.getCode(stack));
            ItemStack personalItem = StackHelper.getPersonalItem(stack);
            if (!personalItem.isEmpty()) {
                tile.setOwner(StackHelper.getOwnerID(stack), personalItem);
                Helpers.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue(VARIANT, (Comparable)((Object)(tile.isTeam() ? EnumType.TEAM : EnumType.PRIVATE)))), (boolean)true);
            }
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        BlockEntity builderTile = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (builderTile instanceof TileEntityEnderChest) {
            ItemStack personal;
            TileEntityEnderChest tile = (TileEntityEnderChest)builderTile;
            Entity builderEntity = (Entity)builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
            if (builderEntity != null && builderEntity.isShiftKeyDown() && !(personal = tile.getPersonalItem()).isEmpty()) {
                drops.forEach(stack -> {
                    if (stack.getItem() == Roster.Items.ENDERCHEST.get()) {
                        StackHelper.setOwner(stack, "all");
                    }
                });
                drops.add(personal);
            }
        }
        return drops;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        TileEntityEnderChest tile = this.getTile((BlockGetter)world, pos);
        if (tile != null) {
            return StackHelper.create(Item.byBlock((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
        }
        return new ItemStack((ItemLike)this);
    }

    public ItemStack getPickBlock(BlockState state, LevelReader world, BlockPos pos, Player player, HitResult target) {
        TileEntityEnderChest tile = this.getTile((BlockGetter)world, pos);
        if (tile != null) {
            if (player != null && !player.isShiftKeyDown()) {
                if (tile.isTeam() && (player.getAbilities().instabuild || tile.getOwnerID().equalsIgnoreCase("#" + Helpers.getPlayerTeamID((Player)player)))) {
                    return StackHelper.create(Item.byBlock((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
                if (!tile.isPublic() && (player.getAbilities().instabuild || tile.getOwnerID().equalsIgnoreCase(player.getUUID().toString()))) {
                    return StackHelper.create(Item.byBlock((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
            }
            return StackHelper.create(Item.byBlock((Block)this), tile.getCode(), null);
        }
        return new ItemStack((ItemLike)this);
    }

    public String getDescriptionId() {
        return "block.enderchests.chest.public";
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        if (rotation != Rotation.NONE) {
            Direction facing = BlockEnderChest.getFacing(state);
            if (rotation == Rotation.CLOCKWISE_180) {
                return (BlockState)state.setValue((Property)FACING, (Comparable)facing.getOpposite());
            }
            int value = facing.ordinal() + (rotation == Rotation.CLOCKWISE_90 ? 1 : -1);
            value = value < 0 ? 5 : (value > 5 ? 0 : value);
            return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.from3DDataValue((int)value));
        }
        return state;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        TileEntityEnderChest tile = this.getTile((BlockGetter)world, pos);
        return tile != null ? AbstractContainerMenu.getRedstoneSignalFromContainer((Container)tile.getInventory()) : 0;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityEnderChest tile;
        if (index > 0 && index < 4 && data.world != null && data.pos != null && (tile = this.getTile((BlockGetter)data.world, data.pos)) != null) {
            int value = Mth.clamp((int)Integer.parseInt("" + tile.getCode().charAt(index - 1), 16), (int)0, (int)16);
            return 0xFF000000 | Configs.PROCESSED.colorValues[value];
        }
        return -1;
    }

    public static Direction getFacing(BlockState state) {
        Direction facing;
        try {
            facing = (Direction)state.getValue((Property)FACING);
        }
        catch (Exception e) {
            facing = Direction.DOWN;
            EnderChests.LOGGER.error("PropertyEnum 'BlockEnderChest.FACING' not found in provided BlockState, returning 'DOWN'. Provided BlockState: " + String.valueOf(state));
        }
        return facing;
    }

    public static enum EnumType implements StringRepresentable
    {
        PUBLIC("public"),
        PRIVATE("private"),
        TEAM("team");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

