/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.crafting;

import com.google.common.base.Strings;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.crafting.AbstractShapedRecipe;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.common.misc.StackHelper;

public class EnderRecipe
extends AbstractShapedRecipe {
    private EnderRecipe(String group, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, CraftingBookCategory.MISC, pattern, result, showNotification);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack result;
        String code = "000";
        block0: for (int index = 0; index < inv.size(); ++index) {
            ItemStack stack = inv.getItem(index);
            if (!TagHelper.isInTag((ItemStack)stack, (TagKey)ItemTags.WOOL)) continue;
            Item item = stack.getItem();
            for (int dye = 1; dye < 16; ++dye) {
                if (!TagHelper.ITEMS.isInTag((Object)item, "c:dyed/" + DyeHelper.NAMES_WB[dye])) continue;
                code = StackHelper.BASE_CODES[dye];
                break block0;
            }
        }
        if (Strings.isNullOrEmpty((String)StackHelper.getOwnerID(result = this.getResultItem(provider).copy()))) {
            StackHelper.setOwner(result, null);
        }
        StackHelper.setCode(result, code);
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Roster.RecipeSerializers.CRAFTING.get();
    }

    public static class Serializer
    extends AbstractShapedRecipe.Serializer<EnderRecipe> {
        protected EnderRecipe createInstance(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
            return new EnderRecipe(group, pattern, result, showNotification);
        }
    }
}

