/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.tileentity;

import com.google.common.base.Strings;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.NameCache;
import shetiphian.core.common.inventory.IContainerCallback;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.IInventoryHolder;
import shetiphian.core.common.tileentity.ILoadStateAware;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.enderchests.Configs;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.component.EnderNetwork;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.LocationManager;
import shetiphian.enderchests.common.misc.StackHelper;

public class TileEntityEnderChest
extends TileEntityBase
implements LidBlockEntity,
IRGB16_Tile,
IContainerCallback,
IInventoryHolder,
ILoadStateAware {
    private EnderNetwork network = EnderNetwork.DEFAULT;
    private float lidAngle;
    private float prevLidAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;
    private final List<String> usedUpgrades = new ArrayList<String>();

    public TileEntityEnderChest(BlockPos pos, BlockState state) {
        super((BlockEntityType)Roster.Tiles.ENDERCHEST.get(), pos, state);
    }

    public void buildNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        nbtTag.put("network", (Tag)EnderNetwork.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.network).getOrThrow());
        if (!this.usedUpgrades.isEmpty()) {
            ListTag listNBT = new ListTag();
            for (String upgrade : this.usedUpgrades) {
                listNBT.add((Object)StringTag.valueOf((String)upgrade));
            }
            nbtTag.put("used_upgrades", (Tag)listNBT);
        }
    }

    public void processNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        if (!nbtTag.contains("network")) {
            this.migrate(nbtTag, provider);
        } else {
            EnderNetwork.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbtTag.get("network")).resultOrPartial().ifPresent(enderNetwork -> {
                this.network = enderNetwork;
            });
        }
        if (nbtTag.contains("used_upgrades", 9)) {
            this.usedUpgrades.clear();
            ListTag listNBT = nbtTag.getList("used_upgrades", 8);
            listNBT.listIterator().forEachRemaining(entry -> this.usedUpgrades.add(entry.getAsString()));
        }
    }

    private void migrate(CompoundTag nbtTag, HolderLookup.Provider provider) {
        if (nbtTag.contains("code", 8)) {
            this.setCode(nbtTag.getString("code"));
        }
        String owner = null;
        if (nbtTag.contains("owner.id", 8)) {
            owner = nbtTag.getString("owner.id");
            String string = owner = StackHelper.isValidOwnerID(owner) ? owner : null;
        }
        if (owner == null && nbtTag.contains("owner_id", 8)) {
            owner = nbtTag.getString("owner_id");
            String string = owner = StackHelper.isValidOwnerID(owner) ? owner : null;
        }
        if (owner != null) {
            String id;
            ItemStack stack = ItemStack.EMPTY;
            if (nbtTag.contains("upgrade.access", 10)) {
                stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtTag.getCompound("upgrade.access"));
                if (!stack.isEmpty() && stack.getCount() != 1) {
                    stack.setCount(1);
                }
            } else if (nbtTag.contains("personal", 8) && !Strings.isNullOrEmpty((String)(id = nbtTag.getString("personal")))) {
                try {
                    stack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)id)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.network = new EnderNetwork(owner, this.network.code(), stack);
        }
    }

    public void processNBT_SaveOnly(CompoundTag nbtTag, HolderLookup.Provider provider) {
        super.processNBT_SaveOnly(nbtTag, provider);
        if (nbtTag.contains("owner.id", 8) && nbtTag.contains("owner", 8)) {
            NameCache.addPlayerNameIfMissing((String)nbtTag.getString("owner.id"), (String)nbtTag.getString("owner"));
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)this.network);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.network = (EnderNetwork)components.getOrDefault((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)EnderNetwork.DEFAULT);
    }

    public boolean applyItem(ItemStack stack) {
        String key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        if (this.usedUpgrades.contains(key)) {
            return false;
        }
        this.usedUpgrades.add(key);
        return true;
    }

    public float getOpenNess(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TileEntityEnderChest tile) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        ++tile.ticksSinceSync;
        if (!world.isClientSide() && tile.numPlayersUsing != 0 && (tile.ticksSinceSync + x + y + z) % 200 == 0) {
            tile.numPlayersUsing = 0;
            for (Player player : world.getEntitiesOfClass(Player.class, new AABB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
                if (!(player.containerMenu instanceof ContainerEnderChest) || !((ContainerEnderChest)player.containerMenu).isParentTile.test((BlockEntity)tile)) continue;
                ++tile.numPlayersUsing;
            }
        }
        tile.prevLidAngle = tile.lidAngle;
        if (tile.numPlayersUsing > 0 && tile.lidAngle == 0.0f) {
            world.playSound(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        }
        if (tile.numPlayersUsing == 0 && tile.lidAngle > 0.0f || tile.numPlayersUsing > 0 && tile.lidAngle < 1.0f) {
            float oldAngle = tile.lidAngle;
            tile.lidAngle = tile.numPlayersUsing > 0 ? (tile.lidAngle += 0.075f) : (tile.lidAngle -= 0.075f);
            if (tile.lidAngle > 1.0f) {
                tile.lidAngle = 1.0f;
            }
            if (tile.lidAngle < 0.5f && oldAngle >= 0.5f) {
                world.playSound(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
            }
            if (tile.lidAngle < 0.0f) {
                tile.lidAngle = 0.0f;
            }
        }
    }

    public float getLidAngle(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public int getLidOffsetIndex() {
        return Math.round(this.lidAngle * 100.0f) / 10;
    }

    public boolean triggerEvent(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
            return true;
        }
        return super.triggerEvent(id, value);
    }

    public boolean isOpen() {
        return this.numPlayersUsing > 0;
    }

    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.invalidateCaps();
    }

    public void invalidateCaps() {
        EnderChests.CAPABILITY_DEVALID_INATOR.accept((BlockEntity)this);
    }

    public boolean canBeAutomated() {
        return this.isPublic() ? (Boolean)Configs.ACCESS_SETTINGS.enableAutomationPublic.get() : (this.isTeam() ? (Boolean)Configs.ACCESS_SETTINGS.enableAutomationTeam.get() : (Boolean)Configs.ACCESS_SETTINGS.enableAutomationPersonal.get());
    }

    public InventoryInternal getInventory() {
        return ChestHelper.getChest(this.level, this.getOwnerID(), this.getCode());
    }

    public boolean canInteractWith(BlockEntity owner, Container inventory, Player player, boolean original) {
        return this.level != null && this.level.getBlockEntity(this.worldPosition) == this && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void onContainerOpen(BlockEntity owner, Container inventory, Player player) {
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        if (!player.isSpectator()) {
            ++this.numPlayersUsing;
            if (this.level != null) {
                this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.numPlayersUsing);
                this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
            }
        }
    }

    public void onContainerClosed(BlockEntity owner, Container inventory, Player player) {
        if (!player.isSpectator()) {
            --this.numPlayersUsing;
            if (this.level != null) {
                this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.numPlayersUsing);
                this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
            }
        }
    }

    public boolean canEdit(Player player) {
        return this.canEdit(player, true);
    }

    public boolean canEdit(Player player, boolean notify) {
        boolean canEdit = true;
        String msg = "";
        if (!player.getAbilities().instabuild) {
            if (this.isTeam()) {
                canEdit = (Boolean)Configs.ACCESS_SETTINGS.lockTeamEdit.get() == false || this.network.id().equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (!this.isPublic()) {
                canEdit = (Boolean)Configs.ACCESS_SETTINGS.lockPersonalEdit.get() == false || !Strings.isNullOrEmpty((String)this.network.id()) && this.network.id().equals(player.getUUID().toString());
                msg = "private.denied";
            }
        }
        if (notify && !canEdit && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "enderchests.chest." + msg);
        }
        return canEdit;
    }

    public boolean canUse(Player player) {
        boolean canUse = true;
        String msg = "";
        if (!player.getAbilities().instabuild) {
            if (this.isTeam()) {
                canUse = (Boolean)Configs.ACCESS_SETTINGS.lockTeamUse.get() == false || this.network.id().equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (this.isPublic()) {
                canUse = (Boolean)Configs.ACCESS_SETTINGS.allowPublicChests.get();
                msg = "public.disabled";
            } else {
                canUse = (Boolean)Configs.ACCESS_SETTINGS.lockPersonalUse.get() == false || !Strings.isNullOrEmpty((String)this.network.id()) && this.network.id().equals(player.getUUID().toString());
                msg = "private.denied";
            }
        }
        if (!canUse && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "enderchests.chest." + msg);
        }
        return canUse;
    }

    public boolean canLink(Player player) {
        boolean canLink = true;
        String msg = "";
        if (!player.getAbilities().instabuild) {
            if (this.isTeam()) {
                if (((Boolean)Configs.ACCESS_SETTINGS.allowTeamBags.get()).booleanValue()) {
                    canLink = (Boolean)Configs.ACCESS_SETTINGS.lockTeamLink.get() == false || this.network.id().equalsIgnoreCase(this.getPlayerTeam(player));
                    msg = "chest.team.denied";
                } else {
                    canLink = false;
                    msg = "bag.team.disabled";
                }
            } else if (!this.isPublic()) {
                if (((Boolean)Configs.ACCESS_SETTINGS.allowPersonalBags.get()).booleanValue()) {
                    canLink = (Boolean)Configs.ACCESS_SETTINGS.lockPersonalLink.get() == false || !Strings.isNullOrEmpty((String)this.network.id()) && this.network.id().equals(player.getUUID().toString());
                    msg = "chest.private.denied";
                } else {
                    canLink = false;
                    msg = "bag.private.disabled";
                }
            }
        }
        if (!canLink && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "enderchests." + msg);
        }
        return canLink;
    }

    private String getPlayerTeam(Player player) {
        String team = Helpers.getPlayerTeamID((Player)player);
        return "#" + (Strings.isNullOrEmpty((String)team) ? "none" : team);
    }

    public String getOwnerID() {
        if (!Strings.isNullOrEmpty((String)this.network.id())) {
            return this.network.id();
        }
        return "all";
    }

    public String getOwnerName() {
        return ChestInfoHelper.getDisplayNameFromOwnerID(this.network.id());
    }

    public void setOwner(Player player, ItemStack stack) {
        this.clearMyLocation();
        this.network = new EnderNetwork(player.getUUID().toString(), this.network.code(), stack);
        this.setMyLocation();
    }

    public void setOwner(String ownerID, ItemStack stack) {
        if (StackHelper.isValidOwnerID(ownerID)) {
            this.clearMyLocation();
            this.network = new EnderNetwork(ownerID, this.network.code(), stack);
            this.setMyLocation();
        }
    }

    public ItemStack getPersonalItem() {
        if (!this.network.stack().isEmpty()) {
            if (this.network.stack().getCount() != 1) {
                this.network.stack().setCount(1);
            }
            return this.network.stack();
        }
        return ItemStack.EMPTY;
    }

    public boolean isPublic() {
        return Strings.isNullOrEmpty((String)this.network.id()) || this.network.id().equalsIgnoreCase("all");
    }

    public boolean isTeam() {
        return this.network.id() != null && this.network.id().startsWith("#");
    }

    public String getCode() {
        return StackHelper.formatCode(this.network.code());
    }

    public void setCode(String code) {
        this.clearMyLocation();
        this.network = new EnderNetwork(this.network.id(), StackHelper.formatCode(code), this.network.stack());
        this.setMyLocation();
        this.invalidateCaps();
    }

    public boolean hasError() {
        return !this.isPublic() && Strings.isNullOrEmpty((String)this.network.id());
    }

    public RGB16 getRGB16(Player player) {
        if (player == null) {
            return null;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return null;
        }
        int value = Integer.parseInt("" + this.getCode().charAt(ring), 16);
        return new RGB16(DyeColor.byId((int)value).getName());
    }

    public boolean setRGB16(short rgbIndex, Player player) {
        return this.doColorRing(DyeColor.byId((int)RGB16Helper.getSimpleColor((short)rgbIndex)), player);
    }

    public boolean doColorRing(DyeColor color, Player player) {
        if (player == null || !this.canEdit(player) || !((Boolean)Configs.GENERAL.inWorldRecoloring.get()).booleanValue()) {
            return false;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return false;
        }
        char charColor = Integer.toHexString(color.getId()).toUpperCase().charAt(0);
        char[] charCode = this.getCode().toCharArray();
        if (charCode[ring] != charColor) {
            charCode[ring] = charColor;
            this.setCode("" + charCode[0] + charCode[1] + charCode[2]);
            Helpers.syncTile((BlockEntity)this);
            return true;
        }
        return false;
    }

    private int getRingHit(Player player) {
        VoxelShape[] shapes = BlockEnderChest.SHAPES.get(this.getBlockState().getValue((Property)BlockEnderChest.FACING));
        return Helpers.getSubShapeHit((Entity)player, (BlockPos)this.worldPosition, (VoxelShape[])shapes) - 1;
    }

    private void setMyLocation() {
        if (this.level != null && !this.level.isClientSide()) {
            LocationManager.set(this.getOwnerID(), this.getCode(), this);
        }
    }

    private void clearMyLocation() {
        if (this.level != null && !this.level.isClientSide()) {
            LocationManager.clear(this.getOwnerID(), this.getCode(), this);
        }
    }

    public void nowLoaded() {
        this.setMyLocation();
    }

    public void nowUnloaded() {
        this.clearMyLocation();
        this.invalidateCaps();
    }
}

