/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.modintegration.jade;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.core.SideExecutor;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public final class JadePlugin
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)ComponentProvider.INSTANCE, TileEntityEnderChest.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)ComponentProvider.INSTANCE, BlockEnderChest.class);
    }

    private static class ComponentProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockAccessor> {
        private static final ComponentProvider INSTANCE = new ComponentProvider();
        private static final ResourceLocation INFO_PROVIDER_ID = EnderChests.RESOURCE.apply("hud");

        private ComponentProvider() {
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            CompoundTag data = accessor.getServerData();
            if (!data.contains("enderchests_basic")) {
                tooltip.add((Component)Component.translatable((String)"hud.enderchests.server_data_missing"));
                return;
            }
            RegistryAccess access = this.getRegistryAccess(accessor.getLevel());
            if (access != null) {
                ArrayList<Component> lines = new ArrayList<Component>();
                ChestInfoHelper.unpackHUDInfo(lines, data.getList("enderchests_basic", 8), (HolderLookup.Provider)access);
                tooltip.addAll(lines);
            }
        }

        public void appendServerData(CompoundTag data, BlockAccessor accessor) {
            BlockEntity blockEntity;
            RegistryAccess access = this.getRegistryAccess(accessor.getLevel());
            if (access != null && (blockEntity = accessor.getBlockEntity()) instanceof TileEntityEnderChest) {
                TileEntityEnderChest tank = (TileEntityEnderChest)blockEntity;
                data.put("enderchests_basic", (Tag)ChestInfoHelper.packHUDBasic(tank, (HolderLookup.Provider)access));
            }
        }

        private RegistryAccess getRegistryAccess(Level world) {
            return (RegistryAccess)SideExecutor.executeOn(() -> () -> Minecraft.getInstance().player.registryAccess(), () -> () -> {
                RegistryAccess registryAccess;
                if (world instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)world;
                    registryAccess = server.registryAccess();
                } else {
                    registryAccess = null;
                }
                return registryAccess;
            });
        }

        public ResourceLocation getUid() {
            return INFO_PROVIDER_ID;
        }
    }
}

