/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.network;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.common.item.IOpenable;
import shetiphian.enderchests.network.PacketOpenBag;

final class ServerPayloadHandler {
    static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    ServerPayloadHandler() {
    }

    void handle(PacketOpenBag packet, Player player) {
        if (packet.location().startsWith("curio|")) {
            Item item;
            ItemStack stack;
            Pair<String, ItemStack> curioData = EnderChests.CURIO_SCANNER.apply((LivingEntity)player, packet.itype());
            if (curioData != null && ((String)curioData.getFirst()).equals(packet.location()) && !(stack = (ItemStack)curioData.getSecond()).isEmpty() && (item = stack.getItem()) instanceof IOpenable) {
                IOpenable openable = (IOpenable)item;
                if (packet.itype().test(stack)) {
                    openable.openInventory(stack, player);
                }
            }
            return;
        }
        if (packet.location().startsWith("inventory|")) {
            Item item;
            ItemStack stack;
            int index = Integer.parseInt(packet.location().substring(10));
            NonNullList items = player.getInventory().items;
            if (index >= 0 && index < items.size() && !(stack = (ItemStack)items.get(index)).isEmpty() && (item = stack.getItem()) instanceof IOpenable) {
                IOpenable openable = (IOpenable)item;
                if (packet.itype().test(stack)) {
                    openable.openInventory(stack, player);
                }
            }
        }
    }
}

