/*
 * Decompiled with CFR 0.152.
 */
package com.recipeessentials.recipecache;

import com.google.gson.JsonElement;
import com.recipeessentials.RecipeEssentials;
import com.recipeessentials.recipecache.CachedRecipeList;
import com.recipeessentials.recipecache.IRecipeCompat;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RecipeManager
extends net.minecraft.world.item.crafting.RecipeManager {
    public static IRecipeCompat compat = new IRecipeCompat(){

        @Override
        public <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder> getRecipe(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn, CachedRecipeList recipes, RecipeManager recipeManager) {
            return Optional.empty();
        }
    };
    private Long2ObjectOpenHashMap<CachedRecipeList> recipeCache = new Long2ObjectOpenHashMap();
    private Object2IntOpenHashMap<RecipeHolder> recipeIndexes = new Object2IntOpenHashMap();

    public RecipeManager(HolderLookup.Provider registryAccess) {
        super(registryAccess);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> recipeTypeIn, I inventoryIn, Level worldIn, @Nullable RecipeHolder<T> recipeHolder) {
        if (inventoryIn.isEmpty()) {
            return Optional.empty();
        }
        long hash = this.calcHash(inventoryIn, recipeTypeIn);
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(hash);
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount * 30) != 0) {
            ++recipes.useCount;
            Optional<RecipeHolder<T>> compatRecipe = compat.getRecipe(recipeTypeIn, inventoryIn, worldIn, recipes, this);
            if (compatRecipe.isPresent()) {
                return compatRecipe;
            }
            int recipesSize = recipes.recipes.size();
            for (int i = 0; i < recipesSize; ++i) {
                RecipeHolder recipe = recipes.recipes.get(i);
                if (!recipe.value().matches(inventoryIn, worldIn)) continue;
                return Optional.of(recipe);
            }
        } else {
            this.getRecipesFor(recipeTypeIn, inventoryIn, worldIn);
        }
        Optional result = super.getRecipeFor(recipeTypeIn, inventoryIn, worldIn, recipeHolder);
        if (result.isPresent() && hash != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            }
            ++recipeList.useCount;
            if (!recipeList.recipes.contains(result.get())) {
                recipeList.recipes.add((RecipeHolder)result.get());
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
        return result;
    }

    public <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn, ResourceLocation resourceLocation) {
        long hash = this.calcHash(inventoryIn, recipeTypeIn);
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(hash);
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount * 30) != 0) {
            ++recipes.useCount;
            Optional<RecipeHolder<T>> compatRecipe = compat.getRecipe(recipeTypeIn, inventoryIn, worldIn, recipes, this);
            if (compatRecipe.isPresent()) {
                return compatRecipe;
            }
            int recipesSize = recipes.recipes.size();
            for (int i = 0; i < recipesSize; ++i) {
                RecipeHolder recipe = recipes.recipes.get(i);
                if (!recipe.value().matches(inventoryIn, worldIn)) continue;
                return Optional.of(recipe);
            }
        } else {
            this.getRecipesFor(recipeTypeIn, inventoryIn, worldIn);
        }
        Optional result = super.getRecipeFor(recipeTypeIn, inventoryIn, worldIn, resourceLocation);
        if (result.isPresent() && hash != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            }
            ++recipeList.useCount;
            if (!recipeList.recipes.contains(result.get())) {
                recipeList.recipes.add((RecipeHolder)result.get());
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
        return result;
    }

    public <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> getRecipesFor(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn) {
        long hash;
        List result;
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn));
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount * 30) != 0) {
            ++recipes.useCount;
            ArrayList<RecipeHolder<T>> matches = new ArrayList<RecipeHolder<T>>();
            for (RecipeHolder recipe2 : recipes.recipes) {
                if (!recipe2.value().matches(inventoryIn, worldIn)) continue;
                matches.add(recipe2);
            }
            if (!matches.isEmpty()) {
                matches.sort(Comparator.comparing(recipe -> recipe.value().getResultItem((HolderLookup.Provider)worldIn.registryAccess()).getDescriptionId()));
                return matches;
            }
        }
        if ((result = super.getRecipesFor(recipeTypeIn, inventoryIn, worldIn)) != null && !result.isEmpty() && (hash = this.calcHash(inventoryIn, recipeTypeIn)) != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            } else {
                ArrayList<RecipeHolder> matches = new ArrayList<RecipeHolder>();
                for (RecipeHolder recipe3 : recipeList.recipes) {
                    if (!recipe3.value().matches(inventoryIn, worldIn)) continue;
                    matches.add(recipe3);
                }
                matches.sort(Comparator.comparing(recipe -> recipe.value().getResultItem((HolderLookup.Provider)worldIn.registryAccess()).getDescriptionId()));
                if (!result.equals(matches)) {
                    recipeList.report(recipeTypeIn, inventoryIn, result);
                }
            }
            ++recipeList.useCount;
            boolean added = false;
            for (RecipeHolder recipe3 : result) {
                if (recipeList.recipes.contains(recipe3)) continue;
                added = true;
                recipeList.recipes.add(recipe3);
            }
            if (added) {
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
        return result;
    }

    public void apply(Map<ResourceLocation, JsonElement> dataMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        super.apply(dataMap, resourceManager, profilerFiller);
        this.recipeCache = new Long2ObjectOpenHashMap();
        int index = 0;
        for (Map.Entry recipe : this.byName.entrySet()) {
            if (!((RecipeHolder)recipe.getValue()).id().equals(recipe.getKey())) {
                RecipeEssentials.LOGGER.warn("Recipe without matching ID:" + String.valueOf(((RecipeHolder)recipe.getValue()).id()));
            }
            this.recipeIndexes.put((Object)((RecipeHolder)recipe.getValue()), index++);
        }
    }

    public void replaceRecipes(Iterable<RecipeHolder<?>> recipeIterator) {
        super.replaceRecipes(recipeIterator);
        this.recipeCache = new Long2ObjectOpenHashMap();
        int index = 0;
        for (RecipeHolder recipe : this.byName.values()) {
            this.recipeIndexes.put((Object)recipe, index++);
        }
    }

    private long calcHash(RecipeInput inventory, RecipeType type) {
        if (inventory == null) {
            return type.hashCode();
        }
        long hash = type.hashCode();
        int size = inventory.size();
        if (inventory.hashCode() != System.identityHashCode(inventory)) {
            hash = 31L * hash + (long)inventory.hashCode();
        }
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack == null || stack.isEmpty()) continue;
            hash = 31L * hash + (long)i;
            hash = 31L * hash + (long)stack.getItem().hashCode();
        }
        return hash;
    }
}

