/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api.internal;

import dev.xylonity.knightlib.api.IBossMusicProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class AbstractLoopSound
extends AbstractTickableSoundInstance {
    private final IBossMusicProvider boss;
    private final int fadeIn;
    private final int fadeOut;
    private int fadeInCounter;
    private int fadeOutCounter;
    private boolean fadingOut;

    public AbstractLoopSound(IBossMusicProvider boss, SoundSource src) {
        super(boss.getBossMusic(), src, SoundInstance.createUnseededRandom());
        this.boss = boss;
        this.looping = true;
        this.relative = true;
        this.volume = 0.0f;
        this.pitch = 1.0f;
        this.attenuation = SoundInstance.Attenuation.NONE;
        this.fadeIn = boss.getFadeIn();
        this.fadeOut = boss.getFadeOut();
        this.fadeInCounter = this.fadeIn;
        this.fadeOutCounter = this.fadeOut;
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (!this.boss.shouldPlayBossMusic((Player)Minecraft.getInstance().player) && !this.fadingOut) {
            this.fadingOut = true;
            this.fadeOutCounter = this.fadeOut;
        }
        if (this.fadingOut) {
            this.volume = (float)this.fadeOutCounter / (float)this.fadeOut;
            if (--this.fadeOutCounter <= 0) {
                this.stop();
            }
        } else {
            this.volume = this.fadeInCounter > 0 ? 1.0f - (float)this.fadeInCounter-- / (float)this.fadeIn : 1.0f;
        }
    }
}

