/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api.internal;

import dev.xylonity.knightlib.api.IBossMusicProvider;
import dev.xylonity.knightlib.api.impl.BossMusicRegistry;
import dev.xylonity.knightlib.api.internal.AbstractLoopSound;
import dev.xylonity.knightlib.mixin.AbstractTickableSoundInstanceAccessor;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class BossMusicManager {
    private static final Map<Integer, AbstractTickableSoundInstance> ACTIVE = new Int2ObjectOpenHashMap();

    private BossMusicManager() {
    }

    public static void clientTick(Minecraft mc) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ACTIVE.values().removeIf(AbstractTickableSoundInstance::isStopped);
        for (IBossMusicProvider entity : BossMusicRegistry.getAll()) {
            Entity e = (Entity)entity;
            int id = e.getId();
            if (ACTIVE.containsKey(id) || !entity.shouldPlayBossMusic((Player)player)) continue;
            AbstractLoopSound sound = new AbstractLoopSound(entity, entity.soundSource());
            mc.getSoundManager().play((SoundInstance)sound);
            ACTIVE.put(id, sound);
        }
    }

    public static void clear() {
        for (AbstractTickableSoundInstance sound : ACTIVE.values()) {
            ((AbstractTickableSoundInstanceAccessor)sound).stopAccessor();
        }
        ACTIVE.clear();
    }
}

