/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.event;

import dev.xylonity.knightlib.api.TickScheduler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="knightlib")
public class KnightLibCommonEvents {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onServerTick(ServerTickEvent.Post event) {
        TickScheduler.clean();
        for (ServerLevel level : event.getServer().getAllLevels()) {
            TickScheduler.incrementTick((Level)level);
            TickScheduler.processServerTasks((Level)level);
            TickScheduler.processCommonTasks((Level)level);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            TickScheduler.markForClean(level);
        }
    }
}

