/*
 * Decompiled with CFR 0.152.
 */
package com.kubepixel.cinematiczoom.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Client CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.DoubleValue firstPersonDefaultZoom;
        public final ModConfigSpec.DoubleValue thirdPersonDefaultZoom;
        public final ModConfigSpec.DoubleValue minZoomFactor;
        public final ModConfigSpec.DoubleValue maxZoomFactor;
        public final ModConfigSpec.DoubleValue zoomStep;
        public final ModConfigSpec.DoubleValue smoothZoomSpeed;
        public final ModConfigSpec.IntValue animationDurationMs;
        public final ModConfigSpec.BooleanValue enableZoomSounds;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Configuraci\u00f3n del Mod Cinematic Zoom").push("general");
            this.firstPersonDefaultZoom = builder.comment("Factor de zoom por defecto en primera persona. Un valor m\u00e1s bajo significa m\u00e1s zoom.").defineInRange("firstPersonDefaultZoom", 0.2, 0.01, 1.0);
            this.thirdPersonDefaultZoom = builder.comment("Factor de zoom por defecto en tercera persona.").defineInRange("thirdPersonDefaultZoom", 0.5, 0.01, 1.0);
            this.minZoomFactor = builder.comment("El nivel m\u00e1s profundo de zoom alcanzable con la rueda del rat\u00f3n.").defineInRange("minZoomFactor", 0.05, 0.01, 1.0);
            this.maxZoomFactor = builder.comment("El nivel m\u00e1s alejado de zoom alcanzable. No puede ser mayor que 1.0.").defineInRange("maxZoomFactor", 1.0, 0.01, 1.0);
            this.zoomStep = builder.comment("Cantidad que cambia el zoom con cada paso de la rueda del rat\u00f3n.").defineInRange("zoomStep", 0.05, 0.001, 0.5);
            this.smoothZoomSpeed = builder.comment("Velocidad de la animaci\u00f3n del zoom al usar la rueda del rat\u00f3n (lerp factor).").defineInRange("smoothZoomSpeed", 0.2, 0.01, 1.0);
            this.animationDurationMs = builder.comment("Duraci\u00f3n en milisegundos de las animaciones de entrada y salida del zoom.").defineInRange("animationDurationMs", 500, 0, 5000);
            this.enableZoomSounds = builder.comment("Activa o desactiva los efectos de sonido al iniciar y detener el zoom.").define("enableZoomSounds", true);
            builder.pop();
        }
    }
}

