/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.event;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.robit.IRobit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

@NothingNullByDefault
public class MekanismTeleportEvent
extends EntityTeleportEvent {
    protected MekanismTeleportEvent(Entity entity, double targetX, double targetY, double targetZ) {
        super(entity, targetX, targetY, targetZ);
    }

    public static class PortableTeleporter
    extends Teleporter {
        private final ItemStack portableTeleporter;

        public PortableTeleporter(Player player, BlockPos teleporterPos, ResourceKey<Level> targetDimension, ItemStack portableTeleporter, long energyCost) {
            super((Entity)player, teleporterPos, targetDimension, energyCost);
            this.portableTeleporter = portableTeleporter;
        }

        public Player getEntity() {
            return (Player)super.getEntity();
        }

        public ItemStack getPortableTeleporter() {
            return this.portableTeleporter;
        }
    }

    public static class Teleporter
    extends GlobalTeleport {
        private final long energyCost;

        public Teleporter(Entity entity, BlockPos teleporterPos, ResourceKey<Level> targetDimension, long energyCost) {
            super(entity, (double)teleporterPos.getX() + 0.5, teleporterPos.getY(), (double)teleporterPos.getZ() + 0.5, targetDimension);
            this.energyCost = energyCost;
        }

        public long getEnergyCost() {
            return this.energyCost;
        }
    }

    public static class Robit
    extends GlobalTeleport {
        public <ROBIT extends Entity> Robit(ROBIT robit) {
            this(robit, Objects.requireNonNull(((IRobit)robit).getHome(), "Robit teleport event cannot be fired for invalid Robits"));
        }

        private <ROBIT extends Entity> Robit(ROBIT robit, GlobalPos homeLocation) {
            super(robit, (double)homeLocation.pos().getX() + 0.5, (double)homeLocation.pos().getY() + 0.3, (double)homeLocation.pos().getZ() + 0.5, (ResourceKey<Level>)homeLocation.dimension());
        }
    }

    public static class GlobalTeleport
    extends MekanismTeleportEvent {
        private final ResourceKey<Level> targetDimension;

        public GlobalTeleport(Entity entity, double targetX, double targetY, double targetZ, ResourceKey<Level> targetDimension) {
            super(entity, targetX, targetY, targetZ);
            this.targetDimension = targetDimension;
        }

        public boolean isTransDimensional() {
            return this.getEntity().level().dimension() != this.targetDimension;
        }

        public ResourceKey<Level> getTargetDimension() {
            return this.targetDimension;
        }
    }

    public static class MekaTool
    extends MekanismTeleportEvent {
        private final BlockHitResult targetBlock;
        private final ItemStack mekaTool;

        public MekaTool(Player player, double targetX, double targetY, double targetZ, ItemStack mekaTool, BlockHitResult targetBlock) {
            super((Entity)player, targetX, targetY, targetZ);
            this.mekaTool = mekaTool;
            this.targetBlock = targetBlock;
        }

        public Player getEntity() {
            return (Player)super.getEntity();
        }

        public ItemStack getMekaTool() {
            return this.mekaTool;
        }

        public BlockHitResult getTargetBlock() {
            return this.targetBlock;
        }
    }
}

