/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class TankCache
extends MultiblockCache<TankMultiblockData> {
    private IFluidContainerManager.ContainerEditMode editMode = IFluidContainerManager.ContainerEditMode.BOTH;

    @Override
    public void merge(MultiblockCache<TankMultiblockData> mergeCache, MultiblockCache.RejectContents rejectContents) {
        super.merge(mergeCache, rejectContents);
        this.editMode = ((TankCache)mergeCache).editMode;
    }

    @Override
    public void apply(HolderLookup.Provider provider, TankMultiblockData data) {
        super.apply(provider, data);
        data.editMode = this.editMode;
    }

    @Override
    public void sync(TankMultiblockData data) {
        super.sync(data);
        this.editMode = data.editMode;
    }

    @Override
    public void load(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.load(provider, nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "edit_mode", IFluidContainerManager.ContainerEditMode.BY_ID, mode -> {
            this.editMode = mode;
        });
    }

    @Override
    public void save(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.save(provider, nbtTags);
        NBTUtils.writeEnum(nbtTags, "edit_mode", this.editMode);
    }
}

