/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongLists;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.text.EnumColor;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.SidedBlockPos;
import mekanism.common.lib.inventory.IAdvancedTransportEjector;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransporterPathfinder {
    private TransporterPathfinder() {
    }

    private static List<Destination> getPaths(LogisticalTransporterBase start, TransporterStack stack, TransitRequest request, int min, Map<GlobalPos, Set<TransporterStack>> additionalFlowingStacks) {
        InventoryNetwork network = (InventoryNetwork)start.getTransmitterNetwork();
        if (network == null) {
            return Collections.emptyList();
        }
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        List<InventoryNetwork.AcceptorData> acceptors = network.calculateAcceptors(request, stack, (Long2ObjectMap<ChunkAccess>)chunkMap, additionalFlowingStacks, start);
        ArrayList<Destination> paths = new ArrayList<Destination>();
        for (InventoryNetwork.AcceptorData data : acceptors) {
            Destination path = TransporterPathfinder.getPath(network, data, start, stack, min, (Long2ObjectMap<ChunkAccess>)chunkMap);
            if (path == null) continue;
            paths.add(path);
        }
        Collections.sort(paths);
        return paths;
    }

    public static boolean checkPath(InventoryNetwork network, LongList path, TransporterStack stack) {
        for (int i = path.size() - 1; i > 0; --i) {
            LogisticalTransporterBase transmitter = (LogisticalTransporterBase)network.getTransmitter(path.getLong(i));
            if (transmitter == null) {
                return false;
            }
            EnumColor color = transmitter.getColor();
            if (color == null || color == stack.color) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Destination getPath(InventoryNetwork network, InventoryNetwork.AcceptorData data, LogisticalTransporterBase start, TransporterStack stack, int min, Long2ObjectMap<ChunkAccess> chunkMap) {
        TransitRequest.TransitResponse response = data.getResponse();
        if (response.getSendingAmount() >= min) {
            BlockPos dest = data.getLocation();
            PathfinderCache.CachedPath test = PathfinderCache.getCache(start, dest, data.getSides());
            if (test != null && TransporterPathfinder.checkPath(network, test.path(), stack)) {
                return new Destination(test, response);
            }
            Pathfinder p = new Pathfinder(network, start.getLevel(), dest, start.getBlockPos(), stack, response.getStack(), (level, pos, tile, s, resp, side) -> TransporterUtils.canInsert(level, pos, tile, s.color, resp, side, false));
            p.find(chunkMap);
            if (p.hasPath()) {
                return new Destination(PathfinderCache.addCachedPath(start, dest, p), response);
            }
        }
        return null;
    }

    @Nullable
    public static Destination getNewBasePath(LogisticalTransporterBase start, TransporterStack stack, TransitRequest request, int min) {
        return TransporterPathfinder.getNewBasePath(start, stack, request, min, Collections.emptyMap());
    }

    @Nullable
    public static Destination getNewBasePath(LogisticalTransporterBase start, TransporterStack stack, TransitRequest request, int min, Map<GlobalPos, Set<TransporterStack>> additionalFlowingStacks) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, request, min, additionalFlowingStacks);
        if (paths.isEmpty()) {
            return null;
        }
        return paths.getFirst();
    }

    @Nullable
    public static Destination getNewRRPath(LogisticalTransporterBase start, TransporterStack stack, TransitRequest request, IAdvancedTransportEjector outputter, int min) {
        SidedBlockPos rrTarget;
        List<Destination> destinations = TransporterPathfinder.getPaths(start, stack, request, min, Collections.emptyMap());
        int destinationCount = destinations.size();
        if (destinationCount == 0) {
            return null;
        }
        if (destinationCount > 1 && (rrTarget = outputter.getRoundRobinTarget()) != null) {
            for (int i = 0; i < destinationCount; ++i) {
                Destination destination = destinations.get(i);
                LongList path = destination.getPath();
                long pos = path.getLong(0);
                if (rrTarget.pos() != pos) continue;
                Direction sideOfDest = WorldUtils.sideDifference(path.getLong(1), pos);
                if (rrTarget.side() != sideOfDest) continue;
                if (i == destinationCount - 1) {
                    outputter.setRoundRobinTarget(destinations.getFirst());
                } else {
                    outputter.setRoundRobinTarget(destinations.get(i + 1));
                }
                return destination;
            }
        }
        Destination destination = destinations.get(0);
        if (destinationCount > 1) {
            outputter.setRoundRobinTarget(destinations.get(1));
        } else {
            outputter.setRoundRobinTarget(destination);
        }
        return destination;
    }

    @Nullable
    public static IdlePathData getIdlePath(LogisticalTransporterBase start, TransporterStack stack) {
        IdlePath d;
        Destination dest;
        InventoryNetwork network = (InventoryNetwork)start.getTransmitterNetwork();
        if (network == null) {
            return null;
        }
        if (stack.homeLocation != Long.MAX_VALUE) {
            Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
            Pathfinder p = new Pathfinder(network, start.getLevel(), BlockPos.of((long)stack.homeLocation), start.getBlockPos(), stack, stack.itemStack, (level, pos, tile, s, resp, side) -> TransporterUtils.canInsert(level, pos, tile, s.color, resp, side, true));
            p.find((Long2ObjectMap<ChunkAccess>)chunkMap);
            if (p.hasPath()) {
                return new IdlePathData(p.getPath(), TransporterStack.Path.HOME);
            }
            stack.homeLocation = Long.MAX_VALUE;
        }
        if ((dest = (d = new IdlePath(network, start.getBlockPos(), stack)).find()) == null) {
            return null;
        }
        return new IdlePathData(dest.getPath(), dest.getPathType());
    }

    public static class Destination
    implements Comparable<Destination> {
        private final TransitRequest.TransitResponse response;
        private final LongList path;
        private final int cachedHash;
        private final double score;
        private TransporterStack.Path pathType = TransporterStack.Path.NONE;

        public Destination(PathfinderCache.CachedPath path, TransitRequest.TransitResponse ret) {
            this(path.path(), ret, path.cost());
        }

        public Destination(LongList path, TransitRequest.TransitResponse ret, double gScore) {
            this.path = path;
            this.cachedHash = this.path.hashCode();
            this.response = ret;
            this.score = gScore;
        }

        public Destination setPathType(TransporterStack.Path type) {
            this.pathType = type;
            return this;
        }

        public int hashCode() {
            return this.cachedHash;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof Destination)) return false;
            Destination other = (Destination)o;
            if (!other.path.equals((Object)this.path)) return false;
            return true;
        }

        @Override
        public int compareTo(@NotNull Destination dest) {
            if (this.score < dest.score) {
                return -1;
            }
            if (this.score > dest.score) {
                return 1;
            }
            return this.path.size() - dest.path.size();
        }

        public TransitRequest.TransitResponse getResponse() {
            return this.response;
        }

        public TransporterStack.Path getPathType() {
            return this.pathType;
        }

        public LongList getPath() {
            return this.path;
        }
    }

    public static class Pathfinder {
        private final LongSet openSet = new LongOpenHashSet();
        private final LongSet closedSet = new LongOpenHashSet();
        private final Long2LongMap navMap = new Long2LongOpenHashMap();
        private final Long2DoubleOpenHashMap gScore = new Long2DoubleOpenHashMap();
        private final Long2DoubleOpenHashMap fScore = new Long2DoubleOpenHashMap();
        private final InventoryNetwork network;
        private final BlockPos start;
        private final BlockPos finalNode;
        private final long finalNodeLong;
        private final TransporterStack transportStack;
        private final ItemStack data;
        private final DestChecker destChecker;
        private final Level world;
        private double finalScore;
        private Direction side;
        private LongList results = new LongArrayList();

        public Pathfinder(InventoryNetwork network, Level world, BlockPos finalNode, BlockPos start, TransporterStack stack, ItemStack data, DestChecker checker) {
            this.destChecker = checker;
            this.network = network;
            this.world = world;
            this.finalNode = finalNode;
            this.finalNodeLong = finalNode.asLong();
            this.start = start;
            this.transportStack = stack;
            this.data = data;
        }

        public boolean find(Long2ObjectMap<ChunkAccess> chunkMap) {
            this.openSet.add(this.start.asLong());
            this.gScore.put(this.start.asLong(), 0.0);
            double totalDistance = WorldUtils.distanceBetween(this.start, this.finalNode);
            this.fScore.put(this.start.asLong(), totalDistance);
            boolean hasValidDirection = false;
            LogisticalTransporterBase startTransmitter = (LogisticalTransporterBase)this.network.getTransmitter(this.start);
            BlockPos.MutableBlockPos neighbor = new BlockPos.MutableBlockPos();
            for (Direction direction : EnumUtils.DIRECTIONS) {
                neighbor.setWithOffset((Vec3i)this.start, direction);
                LogisticalTransporterBase neighborTransmitter = (LogisticalTransporterBase)this.network.getTransmitter((BlockPos)neighbor);
                if (this.transportStack.canInsertToTransporter(neighborTransmitter, direction, startTransmitter)) {
                    hasValidDirection = true;
                    break;
                }
                if (!this.isValidDestination(this.start, startTransmitter, direction, (BlockPos)neighbor, chunkMap)) continue;
                return true;
            }
            if (!hasValidDirection) {
                return false;
            }
            double maxSearchDistance = Math.max(2.0 * totalDistance, 4.0);
            while (!this.openSet.isEmpty()) {
                long currentNodeLong = Long.MAX_VALUE;
                double lowestFScore = 0.0;
                LongIterator longIterator = this.openSet.iterator();
                while (longIterator.hasNext()) {
                    long node = (Long)longIterator.next();
                    if (currentNodeLong != Long.MAX_VALUE && !(this.fScore.get(node) < lowestFScore)) continue;
                    currentNodeLong = node;
                    lowestFScore = this.fScore.get(node);
                }
                if (currentNodeLong == Long.MAX_VALUE) break;
                BlockPos currentNode = BlockPos.of((long)currentNodeLong);
                this.openSet.remove(currentNodeLong);
                this.closedSet.add(currentNodeLong);
                if (WorldUtils.distanceBetween(this.start, currentNode) > maxSearchDistance) continue;
                LogisticalTransporterBase currentNodeTransmitter = (LogisticalTransporterBase)this.network.getTransmitter(currentNode);
                double currentScore = this.gScore.get(currentNodeLong);
                for (Direction direction : EnumUtils.DIRECTIONS) {
                    neighbor.setWithOffset((Vec3i)currentNode, direction);
                    long neighborLong = neighbor.asLong();
                    LogisticalTransporterBase neighborTransmitter = (LogisticalTransporterBase)this.network.getTransmitter((BlockPos)neighbor);
                    if (this.transportStack.canInsertToTransporter(neighborTransmitter, direction, currentNodeTransmitter)) {
                        double tentativeG = currentScore + neighborTransmitter.getCost();
                        if (this.closedSet.contains(neighborLong) && tentativeG >= this.gScore.get(neighborLong) || this.openSet.contains(neighborLong) && !(tentativeG < this.gScore.get(neighborLong))) continue;
                        this.navMap.put(neighborLong, currentNodeLong);
                        this.gScore.put(neighborLong, tentativeG);
                        this.fScore.put(neighborLong, tentativeG + WorldUtils.distanceBetween((BlockPos)neighbor, this.finalNode));
                        this.openSet.add(neighborLong);
                        continue;
                    }
                    if (!this.isValidDestination(currentNode, currentNodeTransmitter, direction, (BlockPos)neighbor, chunkMap)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isValidDestination(BlockPos start, @Nullable LogisticalTransporterBase startTransporter, Direction direction, BlockPos neighbor, Long2ObjectMap<ChunkAccess> chunkMap) {
            BlockEntity neighborTile;
            if (startTransporter != null && neighbor.equals((Object)this.finalNode) && this.destChecker.isValid(this.world, neighbor, neighborTile = WorldUtils.getTileEntity((LevelAccessor)this.world, chunkMap, neighbor), this.transportStack, this.data, direction) && (startTransporter.canEmitTo(direction) || this.finalNodeLong == this.transportStack.homeLocation && startTransporter.canConnect(direction))) {
                this.side = direction;
                this.results = this.reconstructPath(this.navMap, start.asLong());
                this.finalScore = this.gScore.get(start.asLong()) + WorldUtils.distanceBetween(start, this.finalNode);
                return true;
            }
            return false;
        }

        private LongList reconstructPath(Long2LongMap navMap, long nextNode) {
            LongArrayList path = new LongArrayList();
            do {
                path.add(nextNode);
            } while ((nextNode = navMap.getOrDefault(nextNode, Long.MAX_VALUE)) != Long.MAX_VALUE);
            return path;
        }

        public boolean hasPath() {
            return !this.results.isEmpty();
        }

        public LongList getPath() {
            LongArrayList path = new LongArrayList(this.results.size() + 1);
            path.add(this.finalNode.asLong());
            path.addAll(this.results);
            return path;
        }

        public double getFinalScore() {
            return this.finalScore;
        }

        public Direction getSide() {
            return this.side;
        }

        @FunctionalInterface
        public static interface DestChecker {
            public boolean isValid(Level var1, BlockPos var2, @Nullable BlockEntity var3, TransporterStack var4, ItemStack var5, Direction var6);
        }
    }

    public record IdlePathData(LongList path, TransporterStack.Path type) {
    }

    public static class IdlePath {
        private final InventoryNetwork network;
        private final BlockPos start;
        private final TransporterStack transportStack;

        public IdlePath(InventoryNetwork network, BlockPos start, TransporterStack stack) {
            this.network = network;
            this.start = start;
            this.transportStack = stack;
        }

        public Destination find() {
            Destination newPath;
            LongArrayList ret = new LongArrayList();
            ret.add(this.start.asLong());
            LogisticalTransporterBase startTransmitter = (LogisticalTransporterBase)this.network.getTransmitter(this.start);
            if (this.transportStack.idleDir == null) {
                return this.getDestination((LongList)ret, startTransmitter);
            }
            LogisticalTransporterBase transmitter = (LogisticalTransporterBase)this.network.getTransmitter(this.start.relative(this.transportStack.idleDir));
            if (this.transportStack.canInsertToTransporter(transmitter, this.transportStack.idleDir, startTransmitter)) {
                this.loopSide((LongList)ret, this.transportStack.idleDir, startTransmitter);
                return this.createDestination((LongList)ret);
            }
            TransitRequest.SimpleTransitRequest request = TransitRequest.simple(this.transportStack.itemStack);
            if (startTransmitter != null && (newPath = TransporterPathfinder.getNewBasePath(startTransmitter, this.transportStack, request, 0)) != null && newPath.getResponse() != null) {
                this.transportStack.idleDir = null;
                newPath.setPathType(TransporterStack.Path.DEST);
                return newPath;
            }
            return this.getDestination((LongList)ret, startTransmitter);
        }

        @Nullable
        private Destination getDestination(LongList ret, @Nullable LogisticalTransporterBase startTransmitter) {
            Direction newSide = this.findSide(startTransmitter);
            if (newSide == null) {
                if (startTransmitter != null) {
                    Direction sideClosest = this.transportStack.idleDir == null ? this.transportStack.getSide(startTransmitter) : this.transportStack.idleDir;
                    for (Direction side : EnumSet.complementOf(EnumSet.of(sideClosest))) {
                        if (startTransmitter.getConnectionType(side) == ConnectionType.NONE) continue;
                        this.transportStack.idleDir = side;
                        ret.add(WorldUtils.relativePos(this.start.asLong(), side));
                        return this.createDestination(ret);
                    }
                }
                return null;
            }
            this.transportStack.idleDir = newSide;
            this.loopSide(ret, newSide, startTransmitter);
            return this.createDestination(ret);
        }

        private Destination createDestination(LongList ret) {
            LongArrayList path = new LongArrayList(ret);
            Collections.reverse(path);
            return new Destination(LongLists.unmodifiable((LongList)path), null, 0.0);
        }

        private void loopSide(LongList list, Direction side, @Nullable LogisticalTransporterBase startTransmitter) {
            LogisticalTransporterBase lastTransmitter = startTransmitter;
            BlockPos pos = this.start.relative(side);
            LogisticalTransporterBase transmitter = (LogisticalTransporterBase)this.network.getTransmitter(pos);
            while (this.transportStack.canInsertToTransporter(transmitter, side, lastTransmitter)) {
                lastTransmitter = transmitter;
                list.add(pos.asLong());
                pos = pos.relative(side);
                transmitter = (LogisticalTransporterBase)this.network.getTransmitter(pos);
            }
        }

        private Direction findSide(@Nullable LogisticalTransporterBase startTransmitter) {
            if (this.transportStack.idleDir == null) {
                for (Direction side : EnumUtils.DIRECTIONS) {
                    if (!this.canInsertToTransporter(side, startTransmitter)) continue;
                    return side;
                }
            } else {
                Direction opposite = this.transportStack.idleDir.getOpposite();
                for (Direction side : EnumSet.complementOf(EnumSet.of(opposite))) {
                    if (!this.canInsertToTransporter(side, startTransmitter)) continue;
                    return side;
                }
                if (this.canInsertToTransporter(opposite, startTransmitter)) {
                    return opposite;
                }
            }
            return null;
        }

        private boolean canInsertToTransporter(Direction from, @Nullable LogisticalTransporterBase startTransmitter) {
            return this.transportStack.canInsertToTransporter((LogisticalTransporterBase)this.network.getTransmitter(this.start.relative(from)), from, startTransmitter);
        }
    }
}

