/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.common.integration.computer.FactoryRegistry;
import mekanism.common.integration.computer.computercraft.CCCapabilityHelper;
import mekanism.common.integration.crafttweaker.content.CrTContentUtils;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.integration.framedblocks.FramedBlocksIntegration;
import mekanism.common.integration.gender.MekanismGenderArmor;
import mekanism.common.integration.jsonthings.JsonThingsIntegration;
import mekanism.common.integration.lookingat.theoneprobe.TOPProvider;
import mekanism.common.integration.projecte.MekanismNormalizedSimpleStacks;
import mekanism.common.recipe.bin.BinInsertRecipe;
import mekanism.common.registries.MekanismItems;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.loading.DatagenModLoader;

public final class MekanismHooks {
    public final IntegrationInfo computerCraft;
    public final IntegrationInfo craftTweaker;
    public final IntegrationInfo curios;
    public final IntegrationInfo darkModeEverywhere;
    public final IntegrationInfo emi;
    public final IntegrationInfo fluxNetworks;
    public final IntegrationInfo framedBlocks;
    public final IntegrationInfo genderMod;
    public final IntegrationInfo grandPower;
    public final IntegrationInfo jei;
    public final IntegrationInfo jeiTweaker;
    public final IntegrationInfo jsonThings;
    public final IntegrationInfo oc2;
    public final IntegrationInfo projecte;
    public final IntegrationInfo recipeStages;
    public final IntegrationInfo theOneProbe;
    public static final String JEITWEAKER_MOD_ID = "jeitweaker";
    public static final String PROJECTE_MOD_ID = "projecte";

    public MekanismHooks() {
        ModList modList = ModList.get();
        Predicate<String> loadedCheck = modList == null ? modid -> false : arg_0 -> ((ModList)modList).isLoaded(arg_0);
        this.computerCraft = new IntegrationInfo("computercraft", loadedCheck);
        this.craftTweaker = new IntegrationInfo("crafttweaker", loadedCheck);
        this.curios = new IntegrationInfo("curios", loadedCheck);
        this.darkModeEverywhere = new IntegrationInfo("darkmodeeverywhere", loadedCheck);
        this.fluxNetworks = new IntegrationInfo("fluxnetworks", loadedCheck);
        this.grandPower = new IntegrationInfo("grandpower", loadedCheck);
        this.jei = new IntegrationInfo("jei", loadedCheck);
        this.emi = new IntegrationInfo("emi", loadedCheck);
        this.jeiTweaker = new IntegrationInfo(JEITWEAKER_MOD_ID, loadedCheck);
        this.jsonThings = new IntegrationInfo("jsonthings", loadedCheck);
        this.oc2 = new IntegrationInfo("oc2", loadedCheck);
        this.projecte = new IntegrationInfo(PROJECTE_MOD_ID, loadedCheck);
        this.recipeStages = new IntegrationInfo("recipestages", loadedCheck);
        this.theOneProbe = new IntegrationInfo("theoneprobe", loadedCheck);
        this.genderMod = new IntegrationInfo("wildfire_gender", loadedCheck);
        this.framedBlocks = new IntegrationInfo("framedblocks", loadedCheck);
    }

    public void hookConstructor(IEventBus modEventBus) {
        if (this.curios.isLoaded()) {
            CuriosIntegration.addListeners(modEventBus);
        }
        if (this.craftTweaker.isLoaded() && !DatagenModLoader.isRunningDataGen()) {
            modEventBus.addListener(EventPriority.LOWEST, CrTContentUtils::registerCrTContent);
        }
        if (this.jsonThings.isLoaded()) {
            JsonThingsIntegration.hook(modEventBus);
        }
        if (this.projecte.isLoaded()) {
            MekanismNormalizedSimpleStacks.NSS_SERIALIZERS.register(modEventBus);
        }
        if (this.framedBlocks.isLoaded()) {
            FramedBlocksIntegration.init(modEventBus);
        }
    }

    public void hookCapabilityRegistration(RegisterCapabilitiesEvent event) {
        EnergyCompatUtils.initLoadedCache();
        if (this.genderMod.isLoaded()) {
            MekanismGenderArmor.HAZMAT.register(event, MekanismItems.HAZMAT_GOWN);
            MekanismGenderArmor.OPEN_FRONT.register(event, MekanismItems.JETPACK, MekanismItems.SCUBA_TANK);
            MekanismGenderArmor.HIDES_BREASTS.register(event, MekanismItems.ARMORED_JETPACK, MekanismItems.MEKASUIT_BODYARMOR);
        }
    }

    public void hookCommonSetup() {
        if (this.computerCompatEnabled()) {
            FactoryRegistry.load();
            if (this.computerCraft.isLoaded()) {
                CCCapabilityHelper.registerApis();
            }
        }
        if (ModList.get().isLoaded("fastbench")) {
            NeoForge.EVENT_BUS.addListener(BinInsertRecipe::onCrafting);
        }
    }

    public void sendIMCMessages(InterModEnqueueEvent event) {
        if (this.darkModeEverywhere.isLoaded()) {
            this.sendDarkModeEverywhereIMC();
        }
        if (this.theOneProbe.isLoaded()) {
            this.theOneProbe.sendImc("getTheOneProbe", TOPProvider::new);
        }
    }

    public boolean computerCompatEnabled() {
        return this.computerCraft.isLoaded() || this.oc2.isLoaded();
    }

    public boolean recipeViewerCompatEnabled() {
        return this.emi.isLoaded() || this.jei.isLoaded();
    }

    private void sendDarkModeEverywhereIMC() {
        List<Supplier<String>> methodBlacklist = List.of(() -> "mekanism.client.gui.GuiUtils:drawTiledSprite", () -> "mekanism.client.render.HUDRenderer:renderCompass", () -> "mekanism.client.render.HUDRenderer:renderHUDElement");
        for (Supplier<String> method : methodBlacklist) {
            this.darkModeEverywhere.sendImc("dme-shaderblacklist", method);
        }
    }

    public record IntegrationInfo(String modid, boolean isLoaded) {
        private IntegrationInfo(String modid, Predicate<String> loadedCheck) {
            this(modid, loadedCheck.test(modid));
        }

        private void sendImc(String method, Supplier<?> toSend) {
            InterModComms.sendTo((String)this.modid, (String)method, toSend);
        }

        public ResourceLocation rl(String path) {
            return ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
        }

        public void assertLoaded() {
            if (!this.isLoaded) {
                throw new IllegalStateException(this.modid + " is not loaded");
            }
        }
    }
}

