/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.brewery.Brewery;
import org.jetbrains.annotations.NotNull;

public class BrewfestChestplateModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Brewery.identifier("brewfest_chest"), "main");
    private final ModelPart body;
    private final ModelPart left_arm;
    private final ModelPart right_arm;

    public BrewfestChestplateModel(ModelPart root) {
        this.body = root.getChild("body");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.2125f, -2.075f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.3275f)).mirror(false).texOffs(40, 35).addBox(-1.0f, 6.7875f, -2.075f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.3f)).texOffs(0, 16).addBox(-1.0f, -4.2125f, -2.075f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.4f)).texOffs(51, 10).addBox(2.0f, -8.5625f, -1.075f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)5.9125f, (float)0.575f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-3.05f, -4.1667f, -2.05f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.45f)).mirror(false).texOffs(40, 16).mirror().addBox(-3.05f, -2.1667f, -2.05f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.275f)).mirror(false).texOffs(40, 35).mirror().addBox(-3.05f, 6.8333f, -2.05f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.3f)).mirror(false), PartPose.offset((float)-6.2f, (float)11.6667f, (float)0.95f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        this.body.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.right_arm.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.left_arm.render(poseStack, buffer, packedLight, packedOverlay, color);
        poseStack.popPose();
    }

    public void setupAnim(@NotNull T entity, float f, float g, float h, float i, float j) {
    }

    public void copyBody(ModelPart baseBody, ModelPart leftArm, ModelPart rightArm, ModelPart leftLeg, ModelPart rightLeg) {
        this.body.copyFrom(baseBody);
        this.left_arm.copyFrom(leftArm);
        this.right_arm.copyFrom(rightArm);
    }
}

