/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.brewery.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class WallDecorationBlockEntity
extends BlockEntity {
    private final Component[] text = new Component[]{Component.literal((String)""), Component.literal((String)""), Component.literal((String)"")};
    private boolean glowing = false;

    public WallDecorationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.WALL_DECORATION.get(), pos, state);
    }

    public Component getText(int line) {
        return this.text[line];
    }

    public void setText(int line, Component component) {
        this.text[line] = component;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.glowing = compoundTag.getBoolean("Glowing");
        for (int i = 0; i < 3; ++i) {
            if (!compoundTag.contains("Text" + i)) continue;
            this.text[i] = Component.Serializer.fromJson((String)compoundTag.getString("Text" + i), (HolderLookup.Provider)provider);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("Glowing", this.glowing);
        for (int i = 0; i < 3; ++i) {
            tag.putString("Text" + i, Component.Serializer.toJson((Component)this.text[i], (HolderLookup.Provider)provider));
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

