/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.ParticleHelper;

public class ClientParticleHelper
extends ParticleHelper {
    public static void init() {
        INSTANCE = new ClientParticleHelper();
    }

    @Override
    protected boolean crack(BlockState state, Level world, BlockPos pos, Direction side, Object particleEngine, BlockState particles) {
        if (particleEngine instanceof ParticleEngine) {
            ParticleEngine engine = (ParticleEngine)particleEngine;
            if (world instanceof ClientLevel) {
                VoxelShape shape = state.getShape((BlockGetter)world, pos);
                if (!shape.isEmpty()) {
                    int posX = pos.getX();
                    int posY = pos.getY();
                    int posZ = pos.getZ();
                    AABB aabb = shape.bounds();
                    double x = (double)posX + world.random.nextDouble() * (aabb.maxX - aabb.minX - (double)0.2f) + (double)0.1f + aabb.minX;
                    double y = (double)posY + world.random.nextDouble() * (aabb.maxY - aabb.minY - (double)0.2f) + (double)0.1f + aabb.minY;
                    double z = (double)posZ + world.random.nextDouble() * (aabb.maxZ - aabb.minZ - (double)0.2f) + (double)0.1f + aabb.minZ;
                    switch (side) {
                        case DOWN: {
                            y = (double)posY + aabb.minY - (double)0.1f;
                            break;
                        }
                        case UP: {
                            y = (double)posY + aabb.maxY + (double)0.1f;
                            break;
                        }
                        case NORTH: {
                            z = (double)posZ + aabb.minZ - (double)0.1f;
                            break;
                        }
                        case SOUTH: {
                            z = (double)posZ + aabb.maxZ + (double)0.1f;
                            break;
                        }
                        case WEST: {
                            x = (double)posX + aabb.minX - (double)0.1f;
                            break;
                        }
                        case EAST: {
                            x = (double)posX + aabb.maxX + (double)0.1f;
                        }
                    }
                    engine.add(new TerrainParticle((ClientLevel)world, x, y, z, 0.0, 0.0, 0.0, particles, pos).setPower(0.2f).scale(0.6f));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean destroy(BlockState state, Level world, BlockPos pos, Object particleEngine, BlockState particles) {
        if (particleEngine instanceof ParticleEngine) {
            ParticleEngine engine = (ParticleEngine)particleEngine;
            if (world instanceof ClientLevel) {
                VoxelShape voxelshape = state.getShape((BlockGetter)world, pos);
                voxelshape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    double dX = Math.min(1.0, maxX - minX);
                    double dY = Math.min(1.0, maxY - minY);
                    double dZ = Math.min(1.0, maxZ - minZ);
                    int iX = Math.max(2, Mth.ceil((double)(dX / 0.25)));
                    int iY = Math.max(2, Mth.ceil((double)(dY / 0.25)));
                    int iZ = Math.max(2, Mth.ceil((double)(dZ / 0.25)));
                    for (int fX = 0; fX < iX; ++fX) {
                        for (int fY = 0; fY < iY; ++fY) {
                            for (int fZ = 0; fZ < iZ; ++fZ) {
                                double sX = ((double)fX + 0.5) / (double)iX;
                                double sY = ((double)fY + 0.5) / (double)iY;
                                double sZ = ((double)fZ + 0.5) / (double)iZ;
                                double posX = (double)pos.getX() + (sX * dX + minX);
                                double posY = (double)pos.getY() + (sY * dY + minY);
                                double posZ = (double)pos.getZ() + (sZ * dZ + minZ);
                                engine.add((Particle)new TerrainParticle((ClientLevel)world, posX, posY, posZ, sX - 0.5, sY - 0.5, sZ - 0.5, particles, pos));
                            }
                        }
                    }
                });
                return true;
            }
        }
        return false;
    }
}

