/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import shetiphian.core.common.StringUtil;

public class ClientStringUtil
extends StringUtil {
    public static final LoadingCache<String, Component> TRANSLATION_CACHE = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Component>(){

        public Component load(String key) {
            String text = I18n.get((String)key, (Object[])new Object[0]);
            return Component.literal((String)("\u00a7f" + text)).setStyle(StringUtil.computeStyleFrom(text));
        }
    });

    public static void translateAndSplitTooltip(String string, List<Component> list) {
        ClientStringUtil.multiLineTooltip(I18n.get((String)string, (Object[])new Object[0]), list);
    }

    public static void translateAndSplit(String string, List<String> list) {
        ClientStringUtil.multiLine(I18n.get((String)string, (Object[])new Object[0]), list);
    }

    public static String[] translateAll(String ... keys) {
        String[] strings = new String[keys.length];
        for (int index = 0; index < keys.length; ++index) {
            strings[index] = I18n.get((String)keys[index], (Object[])new Object[0]);
        }
        return strings;
    }

    public static Component translateAndComputeStyle(String string) {
        return (Component)TRANSLATION_CACHE.getUnchecked((Object)string);
    }
}

