/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.common.IColored;

public class ColorHandler {
    private static final Set<Block> COLORIZE_BLOCKS = new HashSet<Block>();
    private static final Set<Item> COLORIZE_ITEMS = new HashSet<Item>();

    public static <T extends IColored> void colorize(T iColored) {
        if (iColored instanceof Block) {
            Block block = (Block)iColored;
            COLORIZE_BLOCKS.add(block);
        } else if (iColored instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)iColored;
            COLORIZE_BLOCKS.add(blockItem.getBlock());
            COLORIZE_ITEMS.add((Item)blockItem);
        } else if (iColored instanceof Item) {
            Item item = (Item)iColored;
            COLORIZE_ITEMS.add(item);
        }
    }

    public static void internal_registerBlocks(Consumer<Block> consumer) {
        COLORIZE_BLOCKS.forEach(consumer);
        COLORIZE_BLOCKS.clear();
    }

    public static void internal_registerItems(Consumer<Item> consumer) {
        COLORIZE_ITEMS.forEach(consumer);
        COLORIZE_ITEMS.clear();
    }

    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        public static final ItemColor INSTANCE = new ItemColor();

        public int getColor(ItemStack stack, int tintIndex) {
            if (!stack.isEmpty() && stack.getItem() instanceof IColored) {
                return ((IColored)stack.getItem()).getColorFor(new IColored.Data(stack), tintIndex);
            }
            return 0xFFFFFF;
        }
    }

    public static class BlockColor
    implements net.minecraft.client.color.block.BlockColor {
        public static final BlockColor INSTANCE = new BlockColor();

        public int getColor(BlockState state, BlockAndTintGetter world, BlockPos pos, int tintIndex) {
            if (state != null && state.getBlock() instanceof IColored) {
                return ((IColored)state.getBlock()).getColorFor(new IColored.Data(state, world, pos), tintIndex);
            }
            return 0xFFFFFF;
        }
    }
}

