/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class AbstractWidgetList<E extends AWLEntry<E>>
extends AbstractSelectionList<E> {
    private boolean renderHeader;
    protected int y0;
    protected int y1;
    protected int x0;
    protected int x1;
    private Pair<Integer, Integer> colorsFade = Pair.of((Object)-16777216, (Object)0);
    private Triple<Integer, Integer, Integer> colorsScrollBar = Triple.of((Object)-16777216, (Object)-4144960, (Object)-8355712);
    private Triple<Integer, Integer, Integer> colorsSelectionBox = Triple.of((Object)-16777216, (Object)-1, (Object)-8355712);

    public AbstractWidgetList(Minecraft mc, int x, int y, int width, int height, int entryHeight) {
        super(mc, width, height, y, entryHeight);
        this.setX(x);
        this.y0 = y;
        this.y1 = y + height;
        this.x0 = x;
        this.x1 = x + width;
    }

    protected void setRenderHeader(boolean value, int height) {
        this.renderHeader = value;
        super.setRenderHeader(value, height);
    }

    protected int getScrollbarPosition() {
        return this.x1;
    }

    public int getRowWidth() {
        return this.width;
    }

    protected void renderBackground(GuiGraphics graphics, Tesselator tessellator) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex((float)this.x0, (float)this.y1, 0.0f).setUv((float)this.x0 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).setColor(32, 32, 32, 255);
        bufferbuilder.addVertex((float)this.x1, (float)this.y1, 0.0f).setUv((float)this.x1 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).setColor(32, 32, 32, 255);
        bufferbuilder.addVertex((float)this.x1, (float)this.y0, 0.0f).setUv((float)this.x1 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).setColor(32, 32, 32, 255);
        bufferbuilder.addVertex((float)this.x0, (float)this.y0, 0.0f).setUv((float)this.x0 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).setColor(32, 32, 32, 255);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    protected void renderHoleBackground(GuiGraphics graphics, Tesselator tessellator, int y0, int y1) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex((float)this.x0, (float)y1, 0.0f).setUv(0.0f, (float)y1 / 32.0f).setColor(64, 64, 64, 255);
        bufferbuilder.addVertex((float)(this.x0 + this.width), (float)y1, 0.0f).setUv((float)this.width / 32.0f, (float)y1 / 32.0f).setColor(64, 64, 64, 255);
        bufferbuilder.addVertex((float)(this.x0 + this.width), (float)y0, 0.0f).setUv((float)this.width / 32.0f, (float)y0 / 32.0f).setColor(64, 64, 64, 255);
        bufferbuilder.addVertex((float)this.x0, (float)y0, 0.0f).setUv(0.0f, (float)y0 / 32.0f).setColor(64, 64, 64, 255);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public void setFadeColors(int outer, int inner) {
        this.colorsFade = Pair.of((Object)outer, (Object)inner);
    }

    protected void renderFade(GuiGraphics graphics, Tesselator tessellator) {
        int[] outer = this.getARGB((Integer)this.colorsFade.getLeft());
        int[] inner = this.getARGB((Integer)this.colorsFade.getRight());
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex((float)this.x0, (float)(this.y0 + 4), 0.0f).setUv(0.0f, 1.0f).setColor(inner[1], inner[2], inner[3], inner[0]);
        bufferbuilder.addVertex((float)this.x1, (float)(this.y0 + 4), 0.0f).setUv(1.0f, 1.0f).setColor(inner[1], inner[2], inner[3], inner[0]);
        bufferbuilder.addVertex((float)this.x1, (float)this.y0, 0.0f).setUv(1.0f, 0.0f).setColor(outer[1], outer[2], outer[3], outer[0]);
        bufferbuilder.addVertex((float)this.x0, (float)this.y0, 0.0f).setUv(0.0f, 0.0f).setColor(outer[1], outer[2], outer[3], outer[0]);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex((float)this.x0, (float)this.y1, 0.0f).setUv(0.0f, 1.0f).setColor(outer[1], outer[2], outer[3], outer[0]);
        bufferbuilder.addVertex((float)this.x1, (float)this.y1, 0.0f).setUv(1.0f, 1.0f).setColor(outer[1], outer[2], outer[3], outer[0]);
        bufferbuilder.addVertex((float)this.x1, (float)(this.y1 - 4), 0.0f).setUv(1.0f, 0.0f).setColor(inner[1], inner[2], inner[3], inner[0]);
        bufferbuilder.addVertex((float)this.x0, (float)(this.y1 - 4), 0.0f).setUv(0.0f, 0.0f).setColor(inner[1], inner[2], inner[3], inner[0]);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public void setScrollBarColors(int background, int slider, int shadow) {
        this.colorsScrollBar = Triple.of((Object)background, (Object)slider, (Object)shadow);
    }

    protected void renderScrollbar(GuiGraphics graphics, Tesselator tessellator) {
        int[] back = this.getARGB((Integer)this.colorsScrollBar.getLeft());
        int[] slider = this.getARGB((Integer)this.colorsScrollBar.getMiddle());
        int[] shadow = this.getARGB((Integer)this.colorsScrollBar.getRight());
        int i = this.getScrollbarPosition();
        int j = i + 6;
        int j1 = this.getMaxScroll();
        if (j1 > 0) {
            int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            k1 = Mth.clamp((int)k1, (int)32, (int)(this.y1 - this.y0 - 8));
            int l1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - k1) / j1 + this.y0;
            if (l1 < this.y0) {
                l1 = this.y0;
            }
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            bufferbuilder.addVertex((float)i, (float)this.y1, 0.0f).setColor(back[1], back[2], back[3], back[0]);
            bufferbuilder.addVertex((float)j, (float)this.y1, 0.0f).setColor(back[1], back[2], back[3], back[0]);
            bufferbuilder.addVertex((float)j, (float)this.y0, 0.0f).setColor(back[1], back[2], back[3], back[0]);
            bufferbuilder.addVertex((float)i, (float)this.y0, 0.0f).setColor(back[1], back[2], back[3], back[0]);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            bufferbuilder.addVertex((float)i, (float)(l1 + k1), 0.0f).setColor(shadow[1], shadow[2], shadow[3], shadow[0]);
            bufferbuilder.addVertex((float)j, (float)(l1 + k1), 0.0f).setColor(shadow[1], shadow[2], shadow[3], shadow[0]);
            bufferbuilder.addVertex((float)j, (float)l1, 0.0f).setColor(shadow[1], shadow[2], shadow[3], shadow[0]);
            bufferbuilder.addVertex((float)i, (float)l1, 0.0f).setColor(shadow[1], shadow[2], shadow[3], shadow[0]);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            bufferbuilder.addVertex((float)i, (float)(l1 + k1 - 1), 0.0f).setColor(slider[1], slider[2], slider[3], slider[0]);
            bufferbuilder.addVertex((float)(j - 1), (float)(l1 + k1 - 1), 0.0f).setColor(slider[1], slider[2], slider[3], slider[0]);
            bufferbuilder.addVertex((float)(j - 1), (float)l1, 0.0f).setColor(slider[1], slider[2], slider[3], slider[0]);
            bufferbuilder.addVertex((float)i, (float)l1, 0.0f).setColor(slider[1], slider[2], slider[3], slider[0]);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Tesselator tessellator = Tesselator.getInstance();
        this.renderBackground(graphics, tessellator);
        int rowLeft = this.getRowLeft();
        int l = this.y0 + 4 - (int)this.getScrollAmount();
        this.enableScissor(graphics);
        if (this.renderHeader) {
            this.renderHeader(graphics, rowLeft, l);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ZERO.value, (int)GlStateManager.DestFactor.ONE.value);
        this.renderList(graphics, rowLeft, l, mouseX, mouseY, partialTicks);
        RenderSystem.disableBlend();
        graphics.disableScissor();
        RenderSystem.disableDepthTest();
        this.renderHoleBackground(graphics, tessellator, 0, this.y0);
        this.renderHoleBackground(graphics, tessellator, this.y1, this.height);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ZERO.value, (int)GlStateManager.DestFactor.ONE.value);
        this.renderFade(graphics, tessellator);
        this.renderScrollbar(graphics, tessellator);
        this.renderDecorations(graphics, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    public void setSelectionBoxColors(int background, int border_focused, int border_unfocused) {
        this.colorsSelectionBox = Triple.of((Object)background, (Object)border_focused, (Object)border_unfocused);
    }

    protected void renderSelectionBox(GuiGraphics graphics, Tesselator tessellator, int i1, int itemHeight, int rowWidth) {
        int[] back = this.getARGB((Integer)this.colorsSelectionBox.getLeft());
        int[] border = this.getARGB(this.isFocused() ? (Integer)this.colorsSelectionBox.getMiddle() : (Integer)this.colorsSelectionBox.getRight());
        int l1 = this.x0 + 1 + this.width / 2 - rowWidth / 2;
        int i2 = this.x0 + this.width / 2 + rowWidth / 2;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.addVertex((float)l1, (float)(i1 + itemHeight + 2), 0.0f).setColor(border[1], border[2], border[3], border[0]);
        bufferbuilder.addVertex((float)i2, (float)(i1 + itemHeight + 2), 0.0f).setColor(border[1], border[2], border[3], border[0]);
        bufferbuilder.addVertex((float)i2, (float)(i1 - 2), 0.0f).setColor(border[1], border[2], border[3], border[0]);
        bufferbuilder.addVertex((float)l1, (float)(i1 - 2), 0.0f).setColor(border[1], border[2], border[3], border[0]);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.addVertex((float)(l1 + 1), (float)(i1 + itemHeight + 1), 0.0f).setColor(back[1], back[2], back[3], back[0]);
        bufferbuilder.addVertex((float)(i2 - 1), (float)(i1 + itemHeight + 1), 0.0f).setColor(back[1], back[2], back[3], back[0]);
        bufferbuilder.addVertex((float)(i2 - 1), (float)(i1 - 1), 0.0f).setColor(back[1], back[2], back[3], back[0]);
        bufferbuilder.addVertex((float)(l1 + 1), (float)(i1 - 1), 0.0f).setColor(back[1], back[2], back[3], back[0]);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    protected void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int x = this.getRowLeft();
        int y = this.y0 + 4 - (int)this.getScrollAmount();
        this.renderList(graphics, x, y, mouseX, mouseY, delta);
    }

    protected void renderList(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int i = this.getItemCount();
        Tesselator tessellator = Tesselator.getInstance();
        for (int index = 0; index < i; ++index) {
            int rowTop = this.getRowTop(index);
            int l = this.getRowBottom(index);
            if (l < this.y0 || rowTop > this.y1) continue;
            int i1 = y + index * this.itemHeight + this.headerHeight;
            int itemHeight = this.itemHeight - 4;
            AWLEntry e = (AWLEntry)this.getEntry(index);
            int rowWidth = this.getRowWidth();
            if (this.isSelectedItem(index)) {
                this.renderSelectionBox(graphics, tessellator, i1, itemHeight, rowWidth);
            }
            e.render(graphics, index, rowTop, x, rowWidth, itemHeight, mouseX, mouseY, this.isMouseOver(mouseX, mouseY) && Objects.equals(this.getEntryAtPosition(mouseX, mouseY), (Object)e), partialTicks);
        }
    }

    protected void renderItem(GuiGraphics graphics, int mouseX, int mouseY, float delta, int index, int x, int y, int entryWidth, int entryHeight) {
    }

    private int[] getARGB(int javaColor) {
        return new int[]{(javaColor & 0xFF000000) >> 24, (javaColor & 0xFF0000) >> 16, (javaColor & 0xFF00) >> 8, javaColor & 0xFF};
    }

    public void updateWidgetNarration(NarrationElementOutput elementOutput) {
    }

    public static abstract class AWLEntry<E extends AbstractSelectionList.Entry<E>>
    extends AbstractSelectionList.Entry<E> {
    }
}

