/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.client.gui.ButtonIcon;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.core.client.gui.WidgetInfoBox;
import shetiphian.core.common.inventory.AssignableWorldlyContainer;
import shetiphian.core.common.inventory.SidedContainer;
import shetiphian.core.mixins.SPC_Accessor_Screen;
import shetiphian.core.platform.Services;
import shetiphian.core.self.network.PacketSidedWrapper;

public abstract class GuiSidedContainer<SidedTile extends SidedContainer<?>>
extends AbstractContainerScreen<SidedTile> {
    private final String TEXT_SIDE_DISABLED = I18n.get((String)"gui.side_disabled", (Object[])new Object[0]);
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"shetiphiancore", (String)"textures/gui/info_config.png");
    protected Mode mode = Mode.NORMAL;
    protected WidgetInfoBox infoBox;
    protected byte[] indexSide = new byte[]{-1, -1, -1, -1, -1, -1};
    protected String[] faceNames;
    protected String[] invNames;
    protected Button hoveredButton;
    protected int hoverTime;
    private Button buttonSave;
    public final List<Renderable> renderables;

    public GuiSidedContainer(SidedTile container, boolean rotatable, Inventory inventory, Component title) {
        super(container, inventory, title);
        String[] stringArray;
        if (rotatable) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = "bottom";
            stringArray2[1] = "top";
            stringArray2[2] = "back";
            stringArray2[3] = "front";
            stringArray2[4] = "left";
            stringArray = stringArray2;
            stringArray2[5] = "right";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "down";
            stringArray3[1] = "up";
            stringArray3[2] = "north";
            stringArray3[3] = "south";
            stringArray3[4] = "west";
            stringArray = stringArray3;
            stringArray3[5] = "east";
        }
        this.faceNames = stringArray;
        for (int index = 0; index < 6; ++index) {
            this.faceNames[index] = I18n.get((String)("info." + this.faceNames[index]), (Object[])new Object[0]);
        }
        GuiSidedContainer guiSidedContainer = this;
        if (guiSidedContainer instanceof SPC_Accessor_Screen) {
            SPC_Accessor_Screen accessorScreen = (SPC_Accessor_Screen)((Object)guiSidedContainer);
            this.renderables = accessorScreen.getDrawables();
        } else {
            this.renderables = Lists.newArrayList();
            ShetiPhianCore.LOGGER.error("Mixin Accessor failed to load. GUI will not render or function correctly");
        }
    }

    protected abstract List<String> getInfoBoxText();

    public void init() {
        super.init();
        this.clearWidgets();
        switch (this.mode.ordinal()) {
            case 0: {
                this.addRenderableWidget((GuiEventListener)new ButtonMode(this, this.leftPos - 18, this.topPos + 16, Mode.INFO));
                this.addRenderableWidget((GuiEventListener)new ButtonMode(this, this.leftPos - 18, this.topPos + 40, Mode.CONFIG));
                this.initSidedContainer();
                break;
            }
            case 1: {
                this.addRenderableWidget((GuiEventListener)new ButtonMode(this, this.leftPos - 18, this.topPos + 16, Mode.NORMAL));
                this.addRenderableWidget((GuiEventListener)new ButtonMode(this, this.leftPos - 18, this.topPos + 40, Mode.CONFIG));
                this.infoBox = new WidgetInfoBox(this.minecraft, this.leftPos + 13, this.topPos + this.imageHeight - 84, 158, 72).addHeader(this.getInfoBoxText());
                break;
            }
            case 2: {
                this.addRenderableWidget((GuiEventListener)new ButtonMode(this, this.leftPos - 18, this.topPos + 16, Mode.NORMAL));
                this.addRenderableWidget((GuiEventListener)new ButtonMode(this, this.leftPos - 18, this.topPos + 40, Mode.INFO));
                this.buttonSave = new ButtonSave(this, this.leftPos + 158, this.topPos + this.imageHeight - 88);
                this.addRenderableWidget((GuiEventListener)this.buttonSave);
                if (((SidedContainer)this.menu).getTile() != null) {
                    this.indexSide = (byte[])((AssignableWorldlyContainer)((SidedContainer)this.menu).getTile()).getIndexes().clone();
                }
                int x = this.leftPos + 91;
                int y = this.topPos + this.imageHeight - 48;
                this.addRenderableWidget((GuiEventListener)new ButtonFace(this, x + 1, y - 11, 22, 22, Direction.EAST));
                this.addRenderableWidget((GuiEventListener)new ButtonFace(this, x - 47, y - 11, 22, 22, Direction.WEST));
                this.addRenderableWidget((GuiEventListener)new ButtonFace(this, x - 23, y - 11, 22, 22, Direction.SOUTH));
                this.addRenderableWidget((GuiEventListener)new ButtonFace(this, x + 25, y - 11, 22, 22, Direction.NORTH));
                this.addRenderableWidget((GuiEventListener)new ButtonFace(this, x - 23, y - 35, 22, 22, Direction.UP));
                this.addRenderableWidget((GuiEventListener)new ButtonFace(this, x - 23, y + 13, 22, 22, Direction.DOWN));
            }
        }
    }

    private String getFaceText(int index) {
        return this.faceNames[index].substring(0, 1).toUpperCase();
    }

    protected abstract void initSidedContainer();

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.mode == Mode.NORMAL) {
            super.render(graphics, mouseX, mouseY, partialTicks);
            this.renderTooltip(graphics, mouseX, mouseY);
            return;
        }
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        Services.CLIENT.fireContainerScreenRenderEvent(true, this, graphics, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        Button lastButton = this.hoveredButton;
        this.hoveredButton = null;
        for (Renderable widget : this.renderables) {
            widget.render(graphics, mouseX, mouseY, partialTicks);
            if (!(widget instanceof Button) || !((Button)widget).isMouseOver((double)mouseX, (double)mouseY)) continue;
            if (lastButton != widget) {
                this.hoverTime = 0;
            }
            this.hoveredButton = (Button)widget;
        }
        this.hoverTime = this.hoveredButton == null ? 0 : Mth.clamp((int)(this.hoverTime + 1), (int)0, (int)Integer.MAX_VALUE);
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderLabels(graphics, mouseX, mouseY);
        Services.CLIENT.fireContainerScreenRenderEvent(false, this, graphics, mouseX, mouseY);
        graphics.pose().popPose();
        RenderSystem.enableDepthTest();
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        if (this.mode == Mode.NORMAL) {
            this.drawNormal(graphics, partialTicks, mouseX, mouseY);
            return;
        }
        GuiHelper.drawTexture(graphics, this.leftPos, this.topPos + this.imageHeight - 98, 0, 158, 182, 98, GUI_TEXTURE);
        if (this.mode == Mode.INFO) {
            GuiHelper.drawTexture(graphics, this.leftPos + 12, this.topPos + this.imageHeight - 85, 0, 84, 160, 74, GUI_TEXTURE);
        } else {
            GuiHelper.drawTexture(graphics, this.buttonSave.getX(), this.buttonSave.getY(), 208, 208, this.buttonSave.getWidth(), this.buttonSave.getHeight(), GUI_TEXTURE);
        }
        if (this.mode == Mode.INFO) {
            this.drawInfo(graphics, partialTicks, mouseX, mouseY);
            GuiHelper.drawTexture(graphics, this.leftPos + 12, this.topPos + this.imageHeight - 92, 12, 164, 160, 8, GUI_TEXTURE);
            GuiHelper.drawTexture(graphics, this.leftPos + 12, this.topPos + this.imageHeight - 85, 0, 84, 160, 1, GUI_TEXTURE);
            GuiHelper.drawTexture(graphics, this.leftPos + 12, this.topPos + this.imageHeight - 12, 0, 157, 160, 1, GUI_TEXTURE);
            GuiHelper.drawTexture(graphics, this.leftPos + 12, this.topPos + this.imageHeight - 11, 12, 245, 160, 8, GUI_TEXTURE);
        } else {
            this.drawConfig(graphics, partialTicks, mouseX, mouseY);
        }
    }

    protected abstract void drawNormal(GuiGraphics var1, float var2, int var3, int var4);

    protected abstract void drawInfo(GuiGraphics var1, float var2, int var3, int var4);

    protected abstract void drawConfig(GuiGraphics var1, float var2, int var3, int var4);

    protected void renderFaceButton(GuiGraphics graphics, AbstractWidget button, Direction face, int mouseX, int mouseY, float partialTicks) {
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.mode == Mode.CONFIG && this.hoverTime >= 40 && this.hoveredButton instanceof ButtonFace) {
            int id = ((ButtonFace)this.hoveredButton).faceIndex;
            byte index = this.indexSide[id];
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.literal((String)("\u00a7l" + this.faceNames[id])));
            if (this.invNames != null) {
                list.add(Component.literal((String)("\u00a7o" + (index > -1 && index < this.invNames.length ? this.invNames[index] : this.TEXT_SIDE_DISABLED))));
            }
            graphics.renderComponentTooltip(this.font, list, mouseX - this.leftPos, mouseY - this.topPos);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.mode == Mode.INFO && this.infoBox.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.mode == Mode.INFO && this.infoBox.keyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char character, int value) {
        if (this.mode == Mode.INFO && this.infoBox.charTyped(character, value)) {
            return true;
        }
        return super.charTyped(character, value);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.mode == Mode.INFO && this.infoBox.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double accelX, double accelY) {
        if (this.mode == Mode.INFO && this.infoBox.mouseDragged(mouseX, mouseY, button, accelX, accelY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, accelX, accelY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double hScroll, double vScroll) {
        if (this.mode == Mode.INFO && this.infoBox.mouseScrolled(mouseX, mouseY, hScroll, vScroll)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, hScroll, vScroll);
    }

    protected static enum Mode {
        NORMAL(192, 240, 192, 224, 192, 240),
        INFO(224, 240, 224, 224, 224, 240),
        CONFIG(240, 240, 240, 224, 240, 240);

        private final int[] normal;
        private final int[] hover;
        private final int[] pressed;

        private Mode(int nU, int nV, int hU, int hV, int pU, int pV) {
            this.normal = new int[]{nU, nV};
            this.hover = new int[]{hU, hV};
            this.pressed = new int[]{pU, pV};
        }
    }

    private class ButtonMode
    extends ButtonIcon {
        private final GuiSidedContainer<SidedTile> parent;
        private final Mode mode;

        ButtonMode(GuiSidedContainer guiSidedContainer, int posX, int posY, Mode mode) {
            super(posX, posY, 16, 16, GUI_TEXTURE, mode.normal, mode.hover, mode.pressed);
            this.parent = guiSidedContainer;
            this.mode = mode;
        }

        @Override
        public void onPress() {
            this.parent.mode = this.mode;
            this.parent.init();
        }
    }

    private class ButtonSave
    extends ButtonIcon {
        private final GuiSidedContainer<SidedTile> parent;

        ButtonSave(GuiSidedContainer guiSidedContainer, int posX, int posY) {
            super(posX, posY, 16, 16, GUI_TEXTURE, 208, 240, 208, 224, 208, 240);
            this.parent = guiSidedContainer;
            this.visible = false;
        }

        @Override
        public void onPress() {
            Services.NETWORK.sendToServer(new PacketSidedWrapper(((SidedContainer)this.parent.menu).getTile().getBlockPos(), this.parent.indexSide));
            this.visible = false;
        }
    }

    private class ButtonFace
    extends ButtonIcon {
        private final GuiSidedContainer<SidedTile> parent;
        private final Direction face;
        private final int faceIndex;

        ButtonFace(GuiSidedContainer guiSidedContainer, int posX, int posY, int sizeX, int sizeY, Direction face) {
            super(posX, posY, sizeX, sizeY);
            this.parent = guiSidedContainer;
            this.face = face;
            this.faceIndex = face.get3DDataValue();
            this.setText(this.parent.getFaceText(this.faceIndex));
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            if (!this.visible) {
                return;
            }
            this.parent.renderFaceButton(graphics, (AbstractWidget)this, this.face, mouseX, mouseY, partialTicks);
            if (!Strings.isNullOrEmpty((String)this.displayString)) {
                graphics.drawCenteredString(this.parent.font, this.displayString, this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, -1);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.clicked(mouseX, mouseY)) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                AssignableWorldlyContainer wrapper = (AssignableWorldlyContainer)((SidedContainer)this.parent.menu).getTile();
                byte max = (byte)(wrapper.getGroupCount() - 1);
                switch (button) {
                    case 0: {
                        int n = this.faceIndex;
                        this.parent.indexSide[n] = (byte)(this.parent.indexSide[n] + 1);
                        if (this.parent.indexSide[this.faceIndex] <= max) break;
                        this.parent.indexSide[this.faceIndex] = -1;
                        break;
                    }
                    case 1: {
                        int n = this.faceIndex;
                        this.parent.indexSide[n] = (byte)(this.parent.indexSide[n] - 1);
                        if (this.parent.indexSide[this.faceIndex] >= -1) break;
                        this.parent.indexSide[this.faceIndex] = max;
                        break;
                    }
                    case 2: {
                        this.parent.indexSide[this.faceIndex] = -1;
                    }
                }
                if (this.parent.buttonSave != null) {
                    this.parent.buttonSave.visible = false;
                    byte[] original = wrapper.getIndexes();
                    for (int index = 0; index < 6; ++index) {
                        if (original[index] == this.parent.indexSide[index]) continue;
                        this.parent.buttonSave.visible = true;
                        break;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

