/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.client.model.data.RenderData;

public abstract class BasicBakedModel
implements BakedModel {
    private List<RenderType> blockLayers = null;
    private List<RenderType> itemLayers = null;

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean useAmbientOcclusion(BlockState state, RenderData data, RenderType renderType) {
        return this.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MissingTextureAtlasSprite.getLocation());
    }

    public TextureAtlasSprite getParticleIcon(RenderData data) {
        return this.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public BakedModel setBlockLayers(RenderType ... layers) {
        this.blockLayers = layers == null ? null : (layers.length == 0 ? Collections.emptyList() : ImmutableList.copyOf((Object[])layers));
        return this;
    }

    public BakedModel setBlockLayers(Collection<RenderType> layers) {
        this.blockLayers = layers == null ? null : (layers.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(layers));
        return this;
    }

    public BakedModel setItemLayers(RenderType ... layers) {
        this.itemLayers = layers == null ? null : (layers.length == 0 ? Collections.emptyList() : ImmutableList.copyOf((Object[])layers));
        return this;
    }

    public BakedModel setItemLayers(Collection<RenderType> layers) {
        this.itemLayers = layers == null ? null : (layers.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(layers));
        return this;
    }

    @NotNull
    public final List<RenderType> getBlockLayersOrDefaults(BlockState state, RandomSource random, RenderData data) {
        ImmutableList layers = this.getBlockLayers(state, random, data);
        return layers != null ? layers : ImmutableList.of((Object)ItemBlockRenderTypes.getChunkRenderType((BlockState)state));
    }

    @Nullable
    public List<RenderType> getBlockLayers(BlockState state, RandomSource random, RenderData data) {
        return this.blockLayers;
    }

    @NotNull
    public final List<RenderType> getItemLayersOrDefaults(ItemStack stack, boolean cull) {
        ImmutableList layers = this.getItemLayers(stack, cull);
        return layers != null ? layers : ImmutableList.of((Object)ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)cull));
    }

    @Nullable
    public List<RenderType> getItemLayers(ItemStack stack, boolean cull) {
        return this.itemLayers;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource random, RenderData data, RenderType renderType) {
        return this.getQuads(state, side, random);
    }

    public List<BakedModel> getItemParts(ItemStack stack, RandomSource random, boolean cull) {
        return ImmutableList.of((Object)this);
    }

    protected static List<BakedQuad> getQuadsFrom(BakedModel model, BlockState state, Direction side, RandomSource random, Object data, RenderType renderType) {
        if (model instanceof BasicBakedModel) {
            RenderData renderData;
            BasicBakedModel basicBakedModel = (BasicBakedModel)model;
            return basicBakedModel.getQuads(state, side, random, data instanceof RenderData ? (renderData = (RenderData)data) : RenderData.EMPTY, renderType);
        }
        return model.getQuads(state, side, random);
    }
}

