/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class BlockLightingHelper {
    public static final EnumProperty<PackedData> LIGHTING = EnumProperty.create((String)"lighting", PackedData.class);
    private static final Map<BlockState, Boolean> TRANSMISSIVE = new HashMap<BlockState, Boolean>();
    private static final Map<BlockState, Integer> LUMINOSITY = new HashMap<BlockState, Integer>();

    private static void addBlockData(BlockState state) {
        TRANSMISSIVE.put(state, state.propagatesSkylightDown((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO));
        LUMINOSITY.put(state, state.getLightEmission());
    }

    public static boolean isTransmissive(ItemStack stack) {
        return !stack.isEmpty() && BlockLightingHelper.isTransmissive(stack.getItem());
    }

    public static boolean isTransmissive(Item item) {
        return item instanceof BlockItem && BlockLightingHelper.isTransmissive(((BlockItem)item).getBlock());
    }

    public static boolean isTransmissive(Block block) {
        return BlockLightingHelper.isTransmissive(block.defaultBlockState());
    }

    public static boolean isTransmissive(BlockState state) {
        if (!TRANSMISSIVE.containsKey(state)) {
            BlockLightingHelper.addBlockData(state);
        }
        return TRANSMISSIVE.getOrDefault(state, false);
    }

    public static int getLuminosity(ItemStack stack) {
        return !stack.isEmpty() ? BlockLightingHelper.getLuminosity(stack.getItem()) : 0;
    }

    public static int getLuminosity(Item item) {
        return item instanceof BlockItem ? BlockLightingHelper.getLuminosity(((BlockItem)item).getBlock()) : 0;
    }

    public static int getLuminosity(Block block) {
        return BlockLightingHelper.getLuminosity(block.defaultBlockState());
    }

    public static int getLuminosity(BlockState state) {
        if (!LUMINOSITY.containsKey(state)) {
            BlockLightingHelper.addBlockData(state);
        }
        return LUMINOSITY.getOrDefault(state, 0);
    }

    public static BlockState setLighting(BlockState state, int value, boolean onZeroPassLight) {
        if (state.hasProperty(LIGHTING)) {
            return (BlockState)state.setValue(LIGHTING, (Comparable)((Object)((PackedData)((Object)state.getValue(LIGHTING))).setLight(value, onZeroPassLight)));
        }
        return state;
    }

    public static boolean doesLightPassThrough(BlockState state) {
        return state.hasProperty(LIGHTING) && ((PackedData)((Object)state.getValue(LIGHTING))).passesSkylight();
    }

    public static int getLightValue(BlockState state) {
        return state.hasProperty(LIGHTING) ? ((PackedData)((Object)state.getValue(LIGHTING))).getLightValue() : 0;
    }

    public static enum PackedData implements StringRepresentable
    {
        UNKNOWEN("unknowen"),
        BLOCKING("blocking"),
        PASSING("passing"),
        LVL3("emitting_3"),
        LVL6("emitting_6"),
        LVL9("emitting_9"),
        LVL12("emitting_12"),
        LVL15("emitting_15");

        private final String name;

        private PackedData(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public boolean passesSkylight() {
            return this != UNKNOWEN && this != BLOCKING;
        }

        public int getLightValue() {
            return switch (this.ordinal()) {
                case 3 -> 3;
                case 4 -> 6;
                case 5 -> 9;
                case 6 -> 12;
                case 7 -> 15;
                default -> 0;
            };
        }

        public PackedData setLight(int value, boolean onZeroPassLight) {
            return switch (value / 3 * 3) {
                case 3 -> LVL3;
                case 6 -> LVL6;
                case 9 -> LVL9;
                case 12 -> LVL12;
                case 15 -> LVL15;
                default -> onZeroPassLight ? PASSING : BLOCKING;
            };
        }
    }
}

