/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import shetiphian.core.common.TagHelper;

public class DyeHelper {
    public static final String[] NAMES_WB = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    public static final String[] NAMES_BW = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "light_gray", "gray", "pink", "lime", "yellow", "light_blue", "magenta", "orange", "white"};
    public static final String PREFIX = "c:dyes/";
    private static final HashMap<String, TagKey<Item>> TAGS = new HashMap();
    private static final HashMap<String, DyeColor> DYES = new HashMap();
    private static final HashSet<String> NON_DYES = new HashSet();

    public static String getDyeName(ItemStack stack) {
        return stack.isEmpty() ? "" : DyeHelper.getDyeName(stack.getItem());
    }

    public static String getDyeName(Item item) {
        if (item != null) {
            DyeColor dyeColor = DyeHelper.getDyeColor(item);
            return dyeColor == null ? "" : dyeColor.getName();
        }
        return "";
    }

    public static DyeColor getDyeColor(ItemStack stack) {
        return stack.isEmpty() ? null : DyeHelper.getDyeColor(stack.getItem());
    }

    public static DyeColor getDyeColor(Item item) {
        ResourceLocation entry;
        if (item != null && (entry = BuiltInRegistries.ITEM.getKey((Object)item)) != null) {
            String id = entry.toString();
            if (DYES.containsKey(id)) {
                return DYES.get(id);
            }
            if (!NON_DYES.contains(id)) {
                if (TAGS.isEmpty()) {
                    DyeHelper.generate();
                }
                for (DyeColor dyeColor : DyeColor.values()) {
                    String dyeName = dyeColor.getName();
                    if (!TagHelper.ITEMS.isInTag(item, TAGS.get(dyeName))) continue;
                    DYES.put(id, dyeColor);
                    return dyeColor;
                }
            }
            NON_DYES.add(id);
        }
        return null;
    }

    public static boolean isDye(ItemStack stack) {
        return !stack.isEmpty() && DyeHelper.isDye(stack.getItem());
    }

    public static boolean isDye(Item item) {
        ResourceLocation entry;
        if (item != null && (entry = BuiltInRegistries.ITEM.getKey((Object)item)) != null) {
            String id = entry.toString();
            if (DYES.containsKey(id)) {
                return true;
            }
            if (!NON_DYES.contains(id)) {
                if (TAGS.isEmpty()) {
                    DyeHelper.generate();
                }
                return TagHelper.ITEMS.isInTag(item, TAGS.get("all"));
            }
            NON_DYES.add(id);
        }
        return false;
    }

    private static void generate() {
        TAGS.put("all", TagHelper.ITEMS.getTagKey("c:dyes"));
        for (DyeColor dyeColor : DyeColor.values()) {
            TAGS.put(dyeColor.getName(), TagHelper.ITEMS.getTagKey(PREFIX + dyeColor.getName()));
        }
    }
}

