/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MyDamageSource
extends DamageSource {
    private final String msgBase;

    private static Holder<DamageType> getHolder(ResourceKey<DamageType> damageType, RegistryAccess provider) {
        return provider.registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(damageType);
    }

    public MyDamageSource(Holder<DamageType> damageType) {
        super(damageType);
        this.msgBase = String.format("death.attack.%s", this.type().msgId());
    }

    public MyDamageSource(ResourceKey<DamageType> damageType, RegistryAccess provider) {
        this(MyDamageSource.getHolder(damageType, provider));
    }

    public MyDamageSource(Holder<DamageType> damageType, Entity attacker) {
        super(damageType, attacker);
        this.msgBase = String.format("death.attack.%s.direct", this.type().msgId());
    }

    public MyDamageSource(ResourceKey<DamageType> damageType, Entity attacker, RegistryAccess provider) {
        this(MyDamageSource.getHolder(damageType, provider), attacker);
    }

    public MyDamageSource(Holder<DamageType> damageType, Entity projectile, Entity attacker) {
        super(damageType, projectile, attacker);
        this.msgBase = String.format("death.attack.%s.indirect", this.type().msgId());
    }

    public MyDamageSource(ResourceKey<DamageType> damageType, Entity projectile, Entity attacker, RegistryAccess provider) {
        this(MyDamageSource.getHolder(damageType, provider), projectile, attacker);
    }

    public MyDamageSource(Holder<DamageType> damageType, Vec3 damageSourcePosition) {
        super(damageType, damageSourcePosition);
        this.msgBase = String.format("death.aoe.%s", this.type().msgId());
    }

    public MyDamageSource(ResourceKey<DamageType> damageType, Vec3 damageSourcePosition, RegistryAccess provider) {
        this(MyDamageSource.getHolder(damageType, provider), damageSourcePosition);
    }

    @NotNull
    public Component getLocalizedDeathMessage(LivingEntity victim) {
        Entity attacker = this.getEntity();
        Entity source = this.getDirectEntity();
        if (attacker == null && source == null) {
            attacker = victim.getKillCredit();
            if (attacker != null) {
                ItemStack stack = ((LivingEntity)attacker).getMainHandItem();
                if (!stack.isEmpty() && stack.has(DataComponents.CUSTOM_NAME)) {
                    return Component.translatable((String)(this.msgBase + ".playeritem"), (Object[])new Object[]{victim.getDisplayName(), attacker.getDisplayName(), stack.getDisplayName()});
                }
                return Component.translatable((String)(this.msgBase + ".player"), (Object[])new Object[]{victim.getDisplayName(), attacker.getDisplayName()});
            }
            return Component.translatable((String)this.msgBase, (Object[])new Object[]{victim.getDisplayName()});
        }
        Component text = attacker == null ? source.getDisplayName() : attacker.getDisplayName();
        ItemStack stack = attacker instanceof LivingEntity ? ((LivingEntity)attacker).getMainHandItem() : ItemStack.EMPTY;
        return !stack.isEmpty() && stack.has(DataComponents.CUSTOM_NAME) ? Component.translatable((String)(this.msgBase + ".item"), (Object[])new Object[]{victim.getDisplayName(), text, stack.getDisplayName()}) : Component.translatable((String)this.msgBase, (Object[])new Object[]{victim.getDisplayName(), text});
    }
}

