/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.SideExecutor;
import shetiphian.core.platform.Services;
import shetiphian.core.self.network.PacketNameSyncPlayer;
import shetiphian.core.self.network.PacketNameSyncTeam;
import shetiphian.core.self.teams.TeamHelper;

public class NameCache {
    private static final Cache<String, String> CLIENT_CACHE = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static final Cache<String, String> BUFFER_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static final Map<String, String> TEAMS = Maps.newHashMap();
    private static final Map<UUID, String> PLAYERS = Maps.newHashMap();
    public static final Function<String, String> FALLBACK = id -> String.format("\u2048%s\u2049", id);
    private static final SavedData.Factory<CachedSaveData> SAVE_DATA_TYPE = new SavedData.Factory(CachedSaveData::new, CachedSaveData::load, null);
    private static CachedSaveData SAVE_INSTANCE;

    public static String getDisplayNameFor(String id) {
        try {
            return NameCache.getLastKnownUsername(UUID.fromString(id));
        }
        catch (Exception exception) {
            return NameCache.getLastKnownTeamName(id);
        }
    }

    public static String getLastKnownUsername(UUID uuid) {
        if (PLAYERS.containsKey(uuid)) {
            return PLAYERS.get(uuid);
        }
        String fallback = (String)FALLBACK.apply((Object)uuid.toString());
        if (SideExecutor.isClient()) {
            String id = uuid.toString();
            String name = (String)CLIENT_CACHE.getIfPresent((Object)id);
            if (!Strings.isNullOrEmpty((String)name)) {
                return name;
            }
            name = (String)BUFFER_CACHE.getIfPresent((Object)id);
            if (!Strings.isNullOrEmpty((String)name)) {
                return name;
            }
            BUFFER_CACHE.put((Object)id, (Object)fallback);
            Services.NETWORK.sendToServer(new PacketNameSyncPlayer("?", uuid));
        }
        return fallback;
    }

    public static String getLastKnownTeamName(String teamID) {
        if (TEAMS.containsKey(teamID)) {
            return TEAMS.get(teamID);
        }
        if (TeamHelper.doesTeamExist(teamID)) {
            return TeamHelper.getTeamDisplayName(teamID).getString();
        }
        String fallback = (String)FALLBACK.apply((Object)teamID);
        if (SideExecutor.isClient()) {
            String name = (String)CLIENT_CACHE.getIfPresent((Object)teamID);
            if (!Strings.isNullOrEmpty((String)name)) {
                return name;
            }
            name = (String)BUFFER_CACHE.getIfPresent((Object)teamID);
            if (!Strings.isNullOrEmpty((String)name)) {
                return name;
            }
            BUFFER_CACHE.put((Object)teamID, (Object)fallback);
            Services.NETWORK.sendToServer(new PacketNameSyncTeam("?", teamID));
        }
        return fallback;
    }

    public static void setPlayerName(ServerPlayer player) {
        NameCache.setPlayerName(player.getUUID(), player.getGameProfile().getName());
    }

    public static void setPlayerName(UUID uuid, String name) {
        if (uuid != null && !Strings.isNullOrEmpty((String)name)) {
            if (SideExecutor.isLogicalClient()) {
                CLIENT_CACHE.put((Object)uuid.toString(), (Object)name);
            } else if (!PLAYERS.containsKey(uuid) || !name.equals(PLAYERS.get(uuid))) {
                PLAYERS.put(uuid, name);
                NameCache.setNeedsSaving();
            }
        }
    }

    public static void setTeamName(String teamId, String name) {
        if (!Strings.isNullOrEmpty((String)teamId) && !Strings.isNullOrEmpty((String)name)) {
            if (SideExecutor.isLogicalClient()) {
                CLIENT_CACHE.put((Object)teamId, (Object)name);
            } else {
                TEAMS.put(teamId, name);
            }
        }
    }

    public static void addPlayerNameIfMissing(String id, String name) {
        if (!Strings.isNullOrEmpty((String)id) && !Strings.isNullOrEmpty((String)name) && !id.equals(name) && SideExecutor.isLogicalServer()) {
            try {
                UUID uuid = UUID.fromString(id);
                if (!PLAYERS.containsKey(uuid)) {
                    PLAYERS.put(uuid, name);
                    NameCache.setNeedsSaving();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static void setNeedsSaving() {
        if (SAVE_INSTANCE != null) {
            SAVE_INSTANCE.setDirty();
        }
    }

    public static void load(MinecraftServer server, ServerLevel world) {
        SAVE_INSTANCE = (CachedSaveData)world.getDataStorage().computeIfAbsent(SAVE_DATA_TYPE, "uuid_username_lookup");
    }

    private static class CachedSaveData
    extends SavedData {
        private CachedSaveData() {
        }

        public CompoundTag save(CompoundTag fileNBT, HolderLookup.Provider provider) {
            ShetiPhianCore.LOGGER.debug("Saving Username Cache");
            PLAYERS.forEach((uuid, name) -> fileNBT.putString(uuid.toString(), name));
            ShetiPhianCore.LOGGER.info("Username Cache Saved");
            return fileNBT;
        }

        private static CachedSaveData load(CompoundTag fileNBT, HolderLookup.Provider provider) {
            ShetiPhianCore.LOGGER.debug("Loading Username Cache");
            PLAYERS.clear();
            for (String key : fileNBT.getAllKeys()) {
                try {
                    PLAYERS.put(UUID.fromString(key), fileNBT.getString(key));
                }
                catch (Exception exception) {}
            }
            ShetiPhianCore.LOGGER.info("Username Cache Loaded");
            return new CachedSaveData();
        }
    }
}

