/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class NbtHelper {
    public static boolean isOn(ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_DATA);
    }

    public static CompoundTag getFrom(ItemStack stack) {
        return ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
    }

    public static void setTo(ItemStack stack, CompoundTag tag) {
        if (tag == null || tag.isEmpty()) {
            NbtHelper.removeFrom(stack);
        } else {
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static void removeFrom(ItemStack stack) {
        stack.remove(DataComponents.CUSTOM_DATA);
    }

    public static void process(ItemStack stack, Consumer<CompoundTag> consumer) {
        CompoundTag tag = NbtHelper.getFrom(stack);
        consumer.accept(tag);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
    }
}

