/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TagHelper<Type> {
    public static final TagHelper<Biome> BIOMES = new TagHelper(Registries.BIOME, null, obj -> null);
    public static final TagHelper<Block> BLOCKS = new TagHelper(Registries.BLOCK, BuiltInRegistries.BLOCK, Block::builtInRegistryHolder);
    public static final TagHelper<Item> ITEMS = new TagHelper(Registries.ITEM, BuiltInRegistries.ITEM, Item::builtInRegistryHolder);
    private final HashMap<ResourceLocation, TagKey<Type>> CACHED_TAGS = new HashMap();
    public final TagKey<Type> DUMMY_TAG;
    private final ResourceKey<Registry<Type>> RESOURCEKEY;
    private final DefaultedRegistry<Type> REGISTRY;
    private final Function<Type, Holder<Type>> HOLDER_GETTER;

    public static boolean isInTag(ItemStack stack, TagKey<Item> tagKey) {
        return !stack.isEmpty() && ITEMS.isInTag(stack.getItem(), tagKey);
    }

    public static boolean isInTag(ItemStack stack, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && ITEMS.isInTag(stack.getItem(), ITEMS.getTagKey(tagId));
    }

    public static boolean isInTag(ItemStack stack, Check check, Object ... tags) {
        return !stack.isEmpty() && ITEMS.isInTag(stack.getItem(), check, tags);
    }

    public static Stream<TagKey<Item>> getStream(ItemStack stack) {
        return !stack.isEmpty() ? ITEMS.getStream(stack.getItem()) : Stream.empty();
    }

    public static boolean isInTag(BlockState state, TagKey<Block> tagKey) {
        return state.is(tagKey);
    }

    public static boolean isInTag(BlockState state, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && state.is(BLOCKS.getTagKey(tagId));
    }

    public static boolean isInTag(BlockState state, Check check, Object ... tags) {
        return BLOCKS.isInTag(state.getBlock(), check, tags);
    }

    public static Stream<TagKey<Block>> getStream(BlockState state) {
        return BLOCKS.getStream(state.getBlock());
    }

    public TagHelper(ResourceKey<Registry<Type>> resourceKey, DefaultedRegistry<Type> registry, Function<Type, Holder<Type>> holderGetter) {
        this.DUMMY_TAG = TagKey.create(resourceKey, (ResourceLocation)ResourceLocation.parse((String)"empty_dummy_tag"));
        this.RESOURCEKEY = resourceKey;
        this.REGISTRY = registry;
        this.HOLDER_GETTER = holderGetter;
    }

    public TagKey<Type> getTagKey(ResourceLocation tagId) {
        if (!this.CACHED_TAGS.containsKey(tagId)) {
            TagKey tag = TagKey.create(this.RESOURCEKEY, (ResourceLocation)tagId);
            this.CACHED_TAGS.put(tagId, tag);
        }
        return this.CACHED_TAGS.getOrDefault(tagId, this.DUMMY_TAG);
    }

    public TagKey<Type> getTagKey(String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) ? this.getTagKey(ResourceLocation.parse((String)tagId.toLowerCase(Locale.ROOT))) : this.DUMMY_TAG;
    }

    public boolean isInTag(Holder<Type> holder, TagKey<Type> tagKey) {
        return holder != null && tagKey != null && holder.is(tagKey);
    }

    public boolean isInTag(Type obj, TagKey<Type> tagKey) {
        return obj != null && tagKey != null && this.isInTag((Type)((Holder)this.HOLDER_GETTER.apply(obj)), tagKey);
    }

    public boolean isInTag(Holder<Type> holder, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && this.isInTag((Type)holder, this.getTagKey(tagId));
    }

    public boolean isInTag(Type obj, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && this.isInTag(obj, this.getTagKey(tagId));
    }

    public boolean isInTag(Holder<Type> holder, Check check, Object ... tags) {
        if (holder != null) {
            for (Object tagId : tags) {
                TagKey tagKey;
                TagKey tag = null;
                if (tagId instanceof String) {
                    String string = (String)tagId;
                    if (!Strings.isNullOrEmpty((String)string)) {
                        tag = this.getTagKey(string);
                    }
                } else if (tagId instanceof TagKey && (tagKey = (TagKey)tagId).registry() == this.RESOURCEKEY) {
                    tag = (TagKey)tagId;
                }
                if (tag == null) continue;
                if (holder.is(tag)) {
                    if (check != Check.ANY) continue;
                    return true;
                }
                if (check != Check.ALL) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isInTag(Type obj, Check check, Object ... tags) {
        return obj != null && this.isInTag((Type)((Holder)this.HOLDER_GETTER.apply(obj)), check, tags);
    }

    public Collection<Type> getCollection(TagKey<Type> tagKey) {
        if (this.REGISTRY == null) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        for (Holder holder : this.REGISTRY.getTagOrEmpty(tagKey)) {
            list.add(holder.value());
        }
        return list;
    }

    public Collection<Type> getCollection(String tagId) {
        return this.REGISTRY == null || Strings.isNullOrEmpty((String)tagId) ? Collections.emptyList() : this.getCollection(this.getTagKey(tagId));
    }

    public Stream<TagKey<Type>> getStream(Holder<Type> holder) {
        return holder != null ? holder.tags() : Stream.empty();
    }

    public Stream<TagKey<Type>> getStream(Type obj) {
        return obj != null ? this.getStream((Type)((Holder)this.HOLDER_GETTER.apply(obj))) : Stream.empty();
    }

    public static enum Check {
        ANY,
        ALL;

    }
}

